<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model backend\models\Grupomatricular */

?>
<div class="grupomatricular-view">
    <div class="row">
<?php 
    $gridColumn = [
        [
            'group' =>true,
            'label' => Yii::t('app', 'Grupo Actual'),
            'rowOptions'=>['class'=>'titulo']
        ],
        [
            'columns' => [
                [
                    'attribute' => 'sedeactual',
                    'label' => Yii::t('app', 'Sede'),
                    'value' => $model->sedeactual->sede,
                    'valueHeaderOptions'=>['style'=>'width:15%'],
                    'valueColOptions'=>['style'=>'width:15%'],
                ],
                [
                    'attribute' => 'gradoactual',
                    'label' => Yii::t('app', 'Grado'),
                    'value' => $model->gradoactual->grado,
                    'valueColOptions'=>['style'=>'width:15%'],
                ],
            ],
        ],
        [
            'columns' => [
                [
                    'attribute' => 'jornadaactual',
                    'label' => Yii::t('app', 'Jornada'),
                    'value' => $model->jornadaactual->jornada,
                    'valueColOptions'=>['style'=>'width:15%'],
                ],
                [
                    'attribute' => 'grupoactual',
                    'label' => Yii::t('app', 'Grupo'),
                    'value' => $model->grupoactual->grupo,
                    'valueColOptions'=>['style'=>'width:15%'],
                ],
                
                
            ],
        ],
        [
            'group'=>true,
            'label'=>Yii::t('app', 'Grupo a Matricular'),
            'rowOptions'=>['class'=>'titulo']
        ],
        [
            'columns' => [
                [
                    'attribute' => 'sedenuevo',
                    'label' => Yii::t('app', 'Sede'),
                    'value' => $model->sedenuevo->sede,
                    'valueColOptions'=>['style'=>'width:15%'],
                ],
                [
                    'attribute' => 'gradonuevo',
                    'label' => Yii::t('app', 'Grado'),
                    'value' => $model->gradonuevo->grado,
                    'valueColOptions'=>['style'=>'width:15%'],
                ],
            ],
        ], 
        [
            'columns' => [
                [
                    'attribute' => 'jornadanuevo',
                    'label' => Yii::t('app', 'Jornada'),
                    'value' => $model->jornadanuevo->jornada,
                    'valueColOptions'=>['style'=>'width:15%'],
                ],
                [
                    'attribute' => 'gruponuevo',
                    'label' => Yii::t('app', 'Grupo'),
                    'value' => $model->gruponuevo->grupo,
                    'valueColOptions'=>['style'=>'width:15%'],
                ],
            ],
        ],
    ];


    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        /*'panel' => [
            'heading' => '',
            'type' => DetailView::TYPE_SUCCESS,
        ],*/
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>

    </div>
</div>