<?php

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;

use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\widgets\TouchSpin;
use kartik\widgets\DepDrop;

use backend\models\Sede;
use backend\models\Jornada;
use backend\models\Grado;
use backend\models\Grupo;


?>

<?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>

<?= $form->errorSummary($model); ?>

<?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>


<div class="row">
    <div class="col-sm-6"> <!-- IZQUIERDO -->
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Grupo Actual</h3>
            </div>

            <div class="panel-body" >                
                <div class="col-sm-3">
                    <?= $form->field($model, 'sede_actual')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Sede::find()->orderBy('id')->asArray()->all(), 'id', 'sede'),
                        'options' => ['id'=>'sede-actual-id','placeholder' => 'Sede'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'jornada_actual')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Jornada::find()->orderBy('id')->asArray()->all(), 'id', 'jornada'),
                        'options' => ['id'=>'jornada-actual-id','placeholder' => 'Jornada'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>
                <div class="col-sm-3">

                    <?= $form->field($model, 'grado_actual')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Grado::find()->where(['estado' => '1'])->orderBy('id')->asArray()->all(), 'id', 'grado'),
                        'options' => ['id'=>'grado-actual-id','placeholder' => 'Grado'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>
                <div class="col-sm-3">    
                    <?= $form->field($model, 'grupo_actual')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => ArrayHelper::map(Grupo::find()->where(['=', 'grado', $model->grado_actual])->orderBy('id')->asArray()->all(), 'id', 'grupo'),
                        'options' => ['id'=>'grupo-actual-id','placeholder' => 'Grupo'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Grupo',
                            'depends'=>['sede-actual-id','grado-actual-id','jornada-actual-id'],
                            'url'=>Url::to(['publica/findgruposbygradojornada']),
                        ]
                    ]);
                    ?>  
                </div>
                    
            </div>
        </div>

    </div>


    <div class="col-sm-6"> <!-- DERECHO -->
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Grupo Nuevo</h3>
            </div>

            <div class="panel-body" >                
                <div class="col-sm-3">
                    <?= $form->field($model, 'sede_nuevo')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Sede::find()->orderBy('id')->asArray()->all(), 'id', 'sede'),
                        'options' => ['id'=>'sede-nuevo-id','placeholder' => 'Sede'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($model, 'jornada_nuevo')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Jornada::find()->orderBy('id')->asArray()->all(), 'id', 'jornada'),
                        'options' => ['id'=>'jornada-nuevo-id','placeholder' => 'Jornada'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>
                <div class="col-sm-3">

                    <?= $form->field($model, 'grado_nuevo')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Grado::find()->where(['estado' => '1'])->orderBy('id')->asArray()->all(), 'id', 'grado'),
                        'options' => ['id'=>'grado-nuevo-id','placeholder' => 'Grado'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]); ?>
                </div>
                <div class="col-sm-3">    
                    <?= $form->field($model, 'grupo_nuevo')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => ArrayHelper::map(Grupo::find()->where(['=', 'grado', $model->grado_nuevo])->orderBy('id')->asArray()->all(), 'id', 'grupo'),
                        'options' => ['id'=>'grupo-nuevo-id','placeholder' => 'Grupo'],
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Grupo',
                            'depends'=>['sede-nuevo-id','grado-nuevo-id','jornada-nuevo-id'],
                            'url'=>Url::to(['publica/findgruposbygradojornada']),
                        ]
                    ]);
                    ?>  
                </div>
                    
            </div>
        </div>  
    </div>
</div>

<?php ActiveForm::end(); ?>

<? if(count($grupos) > 0) { ?>

<div class="row">
    <div class="col-sm-12"> <!-- GRUPOS FALTANTES -->

        <div class="alert alert-danger alert-dismissible">
          <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
          <strong><i class="fas fa-angle-double-right"></i> Grupo Pendientes por Configurar</strong>
            &nbsp;&nbsp;
                <?
                    foreach ($grupos as $grupo) {
                        echo '<span class="label label-danger" style="font-size: 14px;">'.$grupo->grupo.'</span> ';
                    }
                ?>
        </div>
    </div>
</div>

<? } ?>

<?php 
    $gridColumn = [
        [
            'class' => 'yii\grid\SerialColumn',
            
        ],
        [
            'class' => 'kartik\grid\ExpandRowColumn',
            'width' => '50px',
            'value' => function ($model, $key, $index, $column) {
                return GridView::ROW_COLLAPSED;
            },
            'detail' => function ($model, $key, $index, $column) {
                return Yii::$app->controller->renderPartial('_expand', ['model' => $model]);
            },
            'headerOptions' => ['class' => 'kartik-sheet-style'],
            'expandOneOnly' => true
        ],
        ['attribute' => 'id', 'visible' => false],
        [
                'attribute' => 'sede_actual',
                'label' => Yii::t('app', 'Sede Actual'),
                'value' => function($model){                   
                    return $model->sedeactual->sede;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Sede::find()->asArray()->all(), 'id', 'sede'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Sede', 'id' => 'grid-gupomatricular-search-sede_actual'],
                'visible' => false,
            ],
        [
                'attribute' => 'grado_actual',
                'label' => Yii::t('app', 'Grado Actual'),
                'value' => function($model){                   
                    return $model->gradoactual->grado;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->asArray()->all(), 'id', 'grado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-gupomatricular-search-grado_actual'],
                'visible' => false,
            ],
        [
                'attribute' => 'jornada_actual',
                'label' => Yii::t('app', 'Jornada Actual'),
                'value' => function($model){                   
                    return $model->jornadaactual->jornada;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Jornada::find()->asArray()->all(), 'id', 'jornada'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Jornada', 'id' => 'grid-gupomatricular-search-jornada_actual'],
                'visible' => false,
            ],
        [
                'attribute' => 'grupo_actual',
                'label' => Yii::t('app', 'Grupo Actual'),
                'format' => "raw",
                'value' => function($model){                   
                    return "<span class='label label-default' style='font-size:14px;'>".$model->grupoactual->grupo."</span>";
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->asArray()->all(), 'id', 'grupo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-gupomatricular-search-grupo_actual'],
                'contentOptions' => function ($model, $key, $index, $column) {
                    return ['style' => 'text-align:center;'];
                },
            ],

        [
                'attribute' => 'direccion',
                'label' => '<abbr title="Grupo a matricular en el próximo año escolar"><i class="fas fa-arrow-alt-square-right text-success"></i></abbr>',
                'encodeLabel' => false,
                'headerOptions' => ['style'=>'text-align:center'],
                'format' => "raw",
                'value' => function($model){                   
                    return "<i class='fas fa-arrow-alt-square-right text-success' style='font-size:26px;'></i>";
                },
                'contentOptions' => function ($model, $key, $index, $column) {
                    return ['style' => 'background-color:#f0f0f0; text-align:center;'];
                },
            ],

        [
                'attribute' => 'sede_nuevo',
                'label' => Yii::t('app', 'Sede Nuevo'),
                'value' => function($model){                   
                    return $model->sedenuevo->sede;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Sede::find()->asArray()->all(), 'id', 'sede'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Sede', 'id' => 'grid-gupomatricular-search-sede_nuevo'],
                'visible' => false,
            ],
        [
                'attribute' => 'grado_nuevo',
                'label' => Yii::t('app', 'Grado Nuevo'),
                'value' => function($model){                   
                    return $model->gradonuevo->grado;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->asArray()->all(), 'id', 'grado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-gupomatricular-search-grado_nuevo'],
                'visible' => false,
            ],
        [
                'attribute' => 'jornada_nuevo',
                'label' => Yii::t('app', 'Jornada Nuevo'),
                'value' => function($model){                   
                    return $model->jornadanuevo->jornada;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Jornada::find()->asArray()->all(), 'id', 'jornada'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Jornada', 'id' => 'grid-gupomatricular-search-jornada_nuevo'],
                'visible' => false,
            ],
        [
                'attribute' => 'grupo_nuevo',
                'label' => Yii::t('app', 'Grupo Nuevo'),
                'format' => "raw",
                'value' => function($model){                   
                    return "<span class='label label-info' style='font-size:14px;'>".$model->gruponuevo->grupo."</span>";
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->asArray()->all(), 'id', 'grupo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-gupomatricular-search-grupo_nuevo'],
                'contentOptions' => function ($model, $key, $index, $column) {
                    return ['style' => 'text-align:center;'];
                },
            ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class'=>'kartik\grid\ActionColumn',
            'width' => '90px',
            'template' => '{update} {delete}',
            'dropdown'=>false,
            'order'=>DynaGrid::ORDER_FIX_RIGHT
        ],
    ]; 
    ?>



<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'gruposamatricular'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>
