<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\GupomatricularSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;

$this->title = Yii::t('app', 'Grupomatricular');
$this->params['breadcrumbs'][] = $this->title;
$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="grupomatricular-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a(Yii::t('app', 'Create Grupomatricular'), ['create'], ['class' => 'btn btn-success']) ?>
        <?= Html::a(Yii::t('app', 'Advance Search'), '#', ['class' => 'btn btn-info search-button']) ?>
    </p>
    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        [
                'attribute' => 'sede_actual',
                'label' => Yii::t('app', 'Sede Actual'),
                'value' => function($model){                   
                    return $model->sedeActual->sede;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Sede::find()->asArray()->all(), 'id', 'sede'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Sede', 'id' => 'grid-gupomatricular-search-sede_actual']
            ],
        [
                'attribute' => 'grado_actual',
                'label' => Yii::t('app', 'Grado Actual'),
                'value' => function($model){                   
                    return $model->gradoActual->grado;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->asArray()->all(), 'id', 'grado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-gupomatricular-search-grado_actual']
            ],
        [
                'attribute' => 'jornada_actual',
                'label' => Yii::t('app', 'Jornada Actual'),
                'value' => function($model){                   
                    return $model->jornadaActual->jornada;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Jornada::find()->asArray()->all(), 'id', 'jornada'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Jornada', 'id' => 'grid-gupomatricular-search-jornada_actual']
            ],
        [
                'attribute' => 'grupo_actual',
                'label' => Yii::t('app', 'Grupo Actual'),
                'value' => function($model){                   
                    return $model->grupoActual->grupo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->asArray()->all(), 'id', 'grupo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-gupomatricular-search-grupo_actual']
            ],
        [
                'attribute' => 'sede_nuevo',
                'label' => Yii::t('app', 'Sede Nuevo'),
                'value' => function($model){                   
                    return $model->sedeNuevo->sede;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Sede::find()->asArray()->all(), 'id', 'sede'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Sede', 'id' => 'grid-gupomatricular-search-sede_nuevo']
            ],
        [
                'attribute' => 'grado_nuevo',
                'label' => Yii::t('app', 'Grado Nuevo'),
                'value' => function($model){                   
                    return $model->gradoNuevo->grado;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->asArray()->all(), 'id', 'grado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-gupomatricular-search-grado_nuevo']
            ],
        [
                'attribute' => 'jornada_nuevo',
                'label' => Yii::t('app', 'Jornada Nuevo'),
                'value' => function($model){                   
                    return $model->jornadaNuevo->jornada;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Jornada::find()->asArray()->all(), 'id', 'jornada'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Jornada', 'id' => 'grid-gupomatricular-search-jornada_nuevo']
            ],
        [
                'attribute' => 'grupo_nuevo',
                'label' => Yii::t('app', 'Grupo Nuevo'),
                'value' => function($model){                   
                    return $model->grupoNuevo->grupo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->asArray()->all(), 'id', 'grupo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-gupomatricular-search-grupo_nuevo']
            ],
        'estado',
        [
            'class' => 'yii\grid\ActionColumn',
        ],
    ]; 
    ?>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => $gridColumn,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-grupomatricular']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span>  ' . Html::encode($this->title),
        ],
        'export' => false,
        // your toolbar can include the additional full export menu
        'toolbar' => [
            '{export}',
            ExportMenu::widget([
                'dataProvider' => $dataProvider,
                'columns' => $gridColumn,
                'target' => ExportMenu::TARGET_BLANK,
                'fontAwesome' => true,
                'dropdownOptions' => [
                    'label' => 'Full',
                    'class' => 'btn btn-default',
                    'itemsBefore' => [
                        '<li class="dropdown-header">Export All Data</li>',
                    ],
                ],
                'exportConfig' => [
                    ExportMenu::FORMAT_PDF => false
                ]
            ]) ,
        ],
    ]); ?>

</div>
