<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Grupomatricular */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Grupomatricular'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="grupomatricular-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Grupomatricular').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'sedeActual.sede',
            'label' => Yii::t('app', 'Sede Actual'),
        ],
        [
            'attribute' => 'gradoActual.grado',
            'label' => Yii::t('app', 'Grado Actual'),
        ],
        [
            'attribute' => 'jornadaActual.jornada',
            'label' => Yii::t('app', 'Jornada Actual'),
        ],
        [
            'attribute' => 'grupoActual.grupo',
            'label' => Yii::t('app', 'Grupo Actual'),
        ],
        [
            'attribute' => 'sedeNuevo.sede',
            'label' => Yii::t('app', 'Sede Nuevo'),
        ],
        [
            'attribute' => 'gradoNuevo.grado',
            'label' => Yii::t('app', 'Grado Nuevo'),
        ],
        [
            'attribute' => 'jornadaNuevo.jornada',
            'label' => Yii::t('app', 'Jornada Nuevo'),
        ],
        [
            'attribute' => 'grupoNuevo.grupo',
            'label' => Yii::t('app', 'Grupo Nuevo'),
        ],
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    <div class="row">
        <h4>Sede<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnSede = [
        ['attribute' => 'id', 'visible' => false],
        'nit',
        'sede',
        'principal',
        'padre',
        'direccion',
        'departamento',
        'municipio',
        'fijo',
        'resolucion',
        'dane',
        'rector_nombre',
        'rector_cc',
        'rector_expedida',
        'rector_movil',
        'rector_email',
        'rector_firma',
        'logo',
        'slogan',
        'vigencia',
        'pdf_header',
        'pdf_footer',
        'pdf_marcadeagua',
        'pdf_marcadeagua_contenido',
        'tipo_calificacion',
        'calificacionxcompetencia',
        'nivelacionxcompetencia',
        'num_calificaciones_saber',
        'por_calificaciones_saber',
        'num_calificaciones_ser',
        'por_calificaciones_ser',
        'psi',
        'num_calificaciones_psi',
        'por_calificaciones_psi',
        'bloquear_boletin',
        'frd',
        'fallas',
        'entrada',
        'compromiso_acudiente',
        'autorizar_calificaciones',
        'autorizar_nivelaciones',
        'bloquear_estudiante',
        'ver_estandar',
        'ver_competencia',
        'ver_niveles',
        'ver_desempenos',
        'ver_frd',
        'ver_criterios',
        'ver_emoticones',
        'ver_puesto',
        'activar_comportamiento',
        'ver_comportamiento_nota',
        'ver_comportamiento_general',
        'ver_comportamiento_especifico',
    ];
    echo DetailView::widget([
        'model' => $model->sedeActual,
        'attributes' => $gridColumnSede    ]);
    ?>
    <div class="row">
        <h4>Grado<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnGrado = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'codigo',
        'tipo_calificacion',
        'calificacionxcompetencia',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->gradoActual,
        'attributes' => $gridColumnGrado    ]);
    ?>
    <div class="row">
        <h4>Jornada<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnJornada = [
        ['attribute' => 'id', 'visible' => false],
        'jornada',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->jornadaActual,
        'attributes' => $gridColumnJornada    ]);
    ?>
    <div class="row">
        <h4>Grupo<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnGrupo = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'grupo',
        'director',
        'jornada',
        'sede',
        'metodologia',
        'modalidad',
        'especialidad',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->grupoActual,
        'attributes' => $gridColumnGrupo    ]);
    ?>
    <div class="row">
        <h4>Sede<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnSede = [
        ['attribute' => 'id', 'visible' => false],
        'nit',
        'sede',
        'principal',
        'padre',
        'direccion',
        'departamento',
        'municipio',
        'fijo',
        'resolucion',
        'dane',
        'rector_nombre',
        'rector_cc',
        'rector_expedida',
        'rector_movil',
        'rector_email',
        'rector_firma',
        'logo',
        'slogan',
        'vigencia',
        'pdf_header',
        'pdf_footer',
        'pdf_marcadeagua',
        'pdf_marcadeagua_contenido',
        'tipo_calificacion',
        'calificacionxcompetencia',
        'nivelacionxcompetencia',
        'num_calificaciones_saber',
        'por_calificaciones_saber',
        'num_calificaciones_ser',
        'por_calificaciones_ser',
        'psi',
        'num_calificaciones_psi',
        'por_calificaciones_psi',
        'bloquear_boletin',
        'frd',
        'fallas',
        'entrada',
        'compromiso_acudiente',
        'autorizar_calificaciones',
        'autorizar_nivelaciones',
        'bloquear_estudiante',
        'ver_estandar',
        'ver_competencia',
        'ver_niveles',
        'ver_desempenos',
        'ver_frd',
        'ver_criterios',
        'ver_emoticones',
        'ver_puesto',
        'activar_comportamiento',
        'ver_comportamiento_nota',
        'ver_comportamiento_general',
        'ver_comportamiento_especifico',
    ];
    echo DetailView::widget([
        'model' => $model->sedeNuevo,
        'attributes' => $gridColumnSede    ]);
    ?>
    <div class="row">
        <h4>Grado<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnGrado = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'codigo',
        'tipo_calificacion',
        'calificacionxcompetencia',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->gradoNuevo,
        'attributes' => $gridColumnGrado    ]);
    ?>
    <div class="row">
        <h4>Jornada<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnJornada = [
        ['attribute' => 'id', 'visible' => false],
        'jornada',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->jornadaNuevo,
        'attributes' => $gridColumnJornada    ]);
    ?>
    <div class="row">
        <h4>Grupo<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnGrupo = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'grupo',
        'director',
        'jornada',
        'sede',
        'metodologia',
        'modalidad',
        'especialidad',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->grupoNuevo,
        'attributes' => $gridColumnGrupo    ]);
    ?>
</div>
