<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\web\JsExpression;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;

?>
     <?php $form = ActiveForm::begin([
        //'validateOnSubmit' => true,
        'enableAjaxValidation' => true,
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'enctype'=>'multipart/form-data',
                    ]
    ]); ?>
    
<div class="row">
    <div class = "col-sm-12">
        <?= $form->errorSummary($model); ?>
    </div>
</div>

<?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

<div class="row gutter">
    <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
        <div class="thumbnail">
            <?= Html::img('@web/images/'.$model->logo, ['class'=>'img-responsive']); ?>

            <h3 class="center-align-text" style="display:block;"><?= $model->instituto ?></h3>
        </div>
        
        <div class="thumbnail" style="padding: 20px !important;">
            <div class="row">
                <div class="col-sm-12">
                    <?= $form->field($model, 'bloquear_boletin')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'size' => 'medium',
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?>
                </div>       
                <div class="col-sm-12">
                    <?= $form->field($model, 'compromiso_acudiente')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'size' => 'medium',
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?>
                </div>       
                <div class="col-sm-12">
                    <?= $form->field($model, 'autorizar_nivelaciones')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'size' => 'medium',
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?>    
                </div>       
                <div class="col-sm-12">
                    <?= $form->field($model, 'bloquear_estudiante')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'size' => 'medium',
                        'onColor' => 'success',
                        'offColor' => 'danger',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?> 
                </div>
            </div> 
        </div>
    </div>       


            
    <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1">Parámetros</a></li>
            <li class=""><a data-toggle="tab" href="#tab-2">Personalizar PDF</a></li>
        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">

                <div class="row">

                    <div class="col-sm-6">
                        <?= $form->field($model, 'instituto')->textInput(['maxlength' => true, 'placeholder' => 'Instituto']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'nit')->textInput(['maxlength' => true, 'placeholder' => 'Nit']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'direccion')->textInput(['maxlength' => true, 'placeholder' => 'Direccion']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'fijo')->textInput(['maxlength' => true, 'placeholder' => 'Fijo']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'resolucion')->textInput(['maxlength' => true, 'placeholder' => 'Resolucion']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'dane')->textInput(['maxlength' => true, 'placeholder' => 'Dane']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_nombre')->textInput(['maxlength' => true, 'placeholder' => 'Rector Nombre']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_cc')->textInput(['maxlength' => true, 'placeholder' => 'Rector Cc']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_expedida')->textInput(['maxlength' => true, 'placeholder' => 'Rector Expedida']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_movil')->textInput(['maxlength' => true, 'placeholder' => 'Rector Movil']) ?>
                    </div>       
                    <div class="col-sm-3">
                        <?= $form->field($model, 'rector_email')->textInput(['maxlength' => true, 'placeholder' => 'Rector Email']) ?>
                    </div>       
       
                    <div class="col-sm-3">
                        <div class="form-group">
                            <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
                            <?= Html::a(Yii::t('app', 'Cancel'), Yii::$app->request->referrer , ['class'=> 'btn btn-danger']) ?>
                        </div>
                    </div>       
                </div>
            </div>  <!-- FIN TAB 1  -->

            <div id="tab-2" class="tab-pane">
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'pdf_header')->textarea(['rows' => 6]) ?>
                    </div>       
                    <div class="col-sm-12" style="padding-bottom: 20px;">
                        <label>Muestra</label>
                        <?= $model->pdf_header ?>
                    </div>
                    <div class="col-sm-12">
                        <?= $form->field($model, 'pdf_footer')->textarea(['rows' => 6]) ?>
                    </div>
                    <div class="col-sm-12" style="padding-bottom: 20px;">
                        <label>Muestra</label>
                        <?= $model->pdf_footer ?>
                    </div>       
                    <div class="col-sm-6">
                        <?= $form->field($model, 'pdf_marcadeagua')->widget(Select2::classname(), [
                            'data' => ['N' => 'Sin Marca', 'I' => 'Imágen', 'T' => 'Texto', 'B' => 'Borrador'],
                            'options' => ['placeholder' => 'Seleccione el Tipo de Marca de Agua'],
                            'pluginOptions' => [
                                'allowClear' => true
                            ],
                        ]); ?>
                    </div>       
                    <div class="col-sm-6">
                        <?= $form->field($model, 'pdf_marcadeagua_contenido')->textInput(['maxlength' => true, 'placeholder' => 'Pdf Marcadeagua Contenido']) ?>
                    </div>       
                </div>
            </div>   
        </div>         
    </div>   
</div>  

<?php ActiveForm::end(); ?>           