<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Instituto */

$this->title = $model->instituto;
$this->params['breadcrumbs'][] = ['label' => 'Instituto', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="instituto-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Instituto'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'nit',
        'instituto',
        'direccion',
        'fijo',
        'resolucion',
        'dane',
        'rector_nombre',
        'rector_cc',
        'rector_expedida',
        'rector_movil',
        'rector_email:email',
        'pdf_header:ntext',
        'pdf_footer:ntext',
        'pdf_marcadeagua',
        'pdf_marcadeagua_contenido',
        'bloquear_boletin',
        'compromiso_acudiente',
        'autorizar_nivelaciones',
        'bloquear_estudiante',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
</div>
