<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Jornada */

$this->title = $model->jornada;
$this->params['breadcrumbs'][] = ['label' => 'Jornadas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="jornada-view">

    <div class="row">
        <div class="col-sm-12">
            <h2><?= 'Jornada'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'jornada',
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnGrupo = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
        'grupo',
        [
                'attribute' => 'tercero.id',
                'label' => 'Director'
        ],
        [
                'attribute' => 'jornada.jornada',
                'label' => 'Jornada'
        ],
        [
                'attribute' => 'sede.sede',
                'label' => 'Sede'
        ],
        'por_nota',
        [
                'attribute' => 'metodologia.metodologia',
                'label' => 'Metodologia'
        ],
        [
                'attribute' => 'modalidad.modalidad',
                'label' => 'Modalidad'
        ],
        [
                'attribute' => 'especialidad.especialidad',
                'label' => 'Especialidad'
        ],
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo Gridview::widget([
        'dataProvider' => $providerGrupo,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-grupo']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Grupo'.' '. $this->title),
        ],
        'columns' => $gridColumnGrupo
    ]);
?>
    </div>
</div>
