<?php
use yii\widgets\Breadcrumbs;
//use dmstr\widgets\Alert;
//use kartik\growl\Growl;

use kartik\widgets\ActiveForm;
use kartik\widgets\Select2;
use yii\db\Expression;
//use backend\assets\AppAsset;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\web\JsExpression;

//use yii\bootstrap\Nav;
//use yii\bootstrap\NavBar;
use common\widgets\Alert;
use yii\widgets\Menu;
use mdm\admin\components\MenuHelper;
use yii\validators\UrlValidator;

use yii\helpers\Url;
use backend\models\Tercero;
use backend\models\TerceroForm;
use backend\models\Sede;
use backend\models\Periodo;
use backend\models\Asistencia;
use backend\models\base\Mensajes;
use backend\widgets\Actions;

$session = Yii::$app->session;

$periodo = new Periodo();

$sede = Sede::findOne(1);

$model = new TerceroForm();

  if ($session->isActive)
  {    
      $doc = Yii::$app->session->get('__doc');

      if ($doc != 'admin')
      {
          $user = Tercero::find()->where(['identificacion' => $doc])->one(); 
      } 
      else
      {
          $user = new Tercero();
          $user->foto = 'sonic.png';
          $user->tipo_tercero = '3';
      }
  }        
          

?>



<script type="text/javascript">
    
    function cambiar_vigencia(vigencia)
    {

      swal({
          title: '¿Deseas cambiar la vigencia?',
          text: 'Deseas cambiar al año escolar ' + vigencia + ', puedes cambiarlo ahora...',
          type: 'warning',
          showCancelButton: true,
          confirmButtonClass: 'btn-warning',
          confirmButtonText: 'Si, estoy seguro!',
          cancelButtonText: 'No, Cancelar',
          closeOnConfirm: false,
          closeOnCancel: false
        },
        function(isConfirm) {
          if (isConfirm) 
          {
            $.ajax({
                    type: 'GET',
                    url: '<?= Url::to(["site/vigencia"]) ?>',
                    data: {vigencia : vigencia},
                    success: function (data) {
                        swal({
                            title: 'Enhorabuena!',
                            text: 'Se ha cambiado a la vigencia ' + data + ' satisfactoriamente, serás redirigido al panel nuevamente.',
                            type: 'success',
                            allowOutsideClick: false,
                            timer: 3000,
                        });

                        window.location.href = '<?= Url::to(["../admin"]) ?>';
                    }
            });  
          } 
          else 
          {
              swal({
                title: 'Cancelado!',
                text: 'Haz cancelado el cambio de vigencia.',
                type: 'error',
                timer: 3000})
          }
      });
    }  

</script>

    <!-- Header Start -->
    <header>
      <a href="<?= Yii::$app->homeUrl ?>" class="logo">
        <!--<img src="<?= $baseUrl?>/img/logo.png" alt="Logo"/>-->
        <? Html::img('@web/images/sonic-logo-blanco.png', ['class' => 'img-responsive', 'style' => 'margin: 0 auto;']); ?>
        <h3>
            <img src="<?= $baseUrl?>/img/logo.png" alt="Logo"/>
            <span class="hidden-xs"> <?= $sede->sede ?></span>
        </h3>
      </a>
      
      <div class="pull-right">              
 
      <?php 
          
          if (Yii::$app->session->get('__tipo') > 1)   
          {  
      ?>          
        <div class="custom-search hidden-sm hidden-xs">

          <?php 

            if(Yii::$app->session->get('__tipo') == 2)
            {
              $actions = ['docente/index'];
            }
            else
            {
              $actions = ['site/index']; 
            }  

            $form = ActiveForm::begin([
                'id' => 'terceroacciones-form', 
                'enableAjaxValidation' => true,
                'action' => $actions,
                'method' => 'post',
            ]); 
          ?>
              
              <?= $form->field($model, 'tercero')->widget(Select2::classname(), [
                      'options' => ['multiple'=>false, 
                        'placeholder' => 'Buscar...',
                        
                        ],
                      'pluginOptions' => [
                          'allowClear' => true,
                          'minimumInputLength' => 3,
                          'language' => [
                              'errorLoading' => new JsExpression("function () { return 'Esperando por resultados...'; }"),
                          ],
                          'ajax' => [
                              'url' => \yii\helpers\Url::to(['tercero/lista']),
                              'dataType' => 'json',
                              'data' => new JsExpression('function(params) { return {q:params.term}; }')
                          ],
                          'escapeMarkup' => new JsExpression('function (markup) { return markup; }'),
                          'templateResult' => new JsExpression('function(tercero) { return tercero.text; }'),
                          'templateSelection' => new JsExpression('function (tercero) { return tercero.text; }'),
                      ],
                      'size' => Select2::SMALL,
                      'addon' => [
                              'append' => [
                                  'content' => Html::submitButton('<i class="fa fa-search" aria-hidden="true"></i>', [
                                      'class' => 'btn btn-success',
                                  ]),
                                  'asButton' => true
                              ]
                          ],
                  ])->label(false);
              ?>      
              
          <?php ActiveForm::end(); ?>

        </div>

      <?php   
        }
      ?>

        <ul id="mini-nav" class="clearfix">

          <li class="list-box dropdown server-activity">
            <?= Html::a(
                            '<span class="badge badge-warning">'.$sede->vigencia.'</span> <span class="badge badge-success">'.$periodo->actual->id.'</span>',
                            false,
                            [
                              'title' => 'Año Escolar y Periodo',
                              'id' => 'drop5',
                              'role' => 'button',
                              'class' => 'dropdown-toggle',
                              'data-toggle' => 'dropdown',
                              'style' => 'padding: 10px 10px 0px 10px;',
                            ]
                        )
            ?>
                        
            <?php if (($session->isActive) AND (Yii::$app->session->get('__tipo') > 2)) { ?>
            
              <ul class="dropdown-menu server-activity clearfix">                
                  <li>
                      <p>
                        <i class="fa fa-database text-primary" aria-hidden="true"></i> Año Escolar
                        <span class="time">
                          <?= Html::a(
                                '2025',
                                false,
                                [
                                  'title' => 'Año Escolar 2025',
                                  'class' => 'btn btn-xs btn-primary',
                                  'style' => 'padding: 10px 20px 5px 20px;',
                                  'onclick' => 'cambiar_vigencia(2025);',
                                ]
                              );
                          ?>
                        </span>
                      </p>
                  </li>
                  <li>
                      <p>
                        <i class="fa fa-database text-success" aria-hidden="true"></i> Año Escolar
                        <span class="time">
                          <?= Html::a(
                                '2024',
                                false,
                                [
                                  'title' => 'Año Escolar 2024',
                                  'class' => 'btn btn-xs btn-success',
                                  'style' => 'padding: 10px 20px 5px 20px;',
                                  'onclick' => 'cambiar_vigencia(2024);',
                                ]
                              );
                          ?>
                        </span>
                      </p>
                  </li>
                  <li>
                      <p>
                        <i class="fa fa-database text-success" aria-hidden="true"></i> Año Escolar
                        <span class="time">
                          <?= Html::a(
                                '2023',
                                false,
                                [
                                  'title' => 'Año Escolar 2023',
                                  'class' => 'btn btn-xs btn-success',
                                  'style' => 'padding: 10px 20px 5px 20px;',
                                  'onclick' => 'cambiar_vigencia(2023);',
                                ]
                              );
                          ?>
                        </span>
                      </p>
                  </li>

                  <li>
                      <p>
                        <i class="fa fa-database text-success" aria-hidden="true"></i> Año Escolar
                        <span class="time">
                          <?= Html::a(
                                '2022',
                                false,
                                [
                                  'title' => 'Año Escolar 2022',
                                  'class' => 'btn btn-xs btn-success',
                                  'style' => 'padding: 10px 20px 5px 20px;',
                                  'onclick' => 'cambiar_vigencia(2022);',
                                ]
                              );
                          ?>
                        </span>
                      </p>
                  </li>

                  <?php for ($v="2021"; $v >= "2011"; $v--) { ?>
                      
                    <li>
                        <p>
                          <i class="fa fa-database text-warning" aria-hidden="true"></i> Año Escolar
                          <span class="time">
                            <?= Html::a(
                                  $v,
                                  Url::to('https://www.gabrielamistralacacias.edu.co/san'.$v.'/'),
                                  [
                                    'title' => 'Año Escolar '.$v,
                                    'class' => 'btn btn-xs btn-warning',
                                    'style' => 'padding: 10px 20px 5px 20px;',
                                    'target' => '_blank',
                                  ]
                                );
                            ?>
                          </span>
                        </p>
                    </li>

                  <?php } ?>
              </ul>
            <?php } ?>
          </li>

          <li class="list-box dropdown">
            <?= Html::a(
                            '<i class="far fa-envelope"></i>',
                            ['/mensajes/index'],
                            [
                              'title' => 'Mensajes Nuevos',
                              'id' => 'drop5',
                              'role' => 'button',
                              'style' => 'padding: 10px;'
                            ]
                        )
            ?>
              <? 
                  $mensajes = Mensajes::find()
                      ->select(['COUNT(mensaje) as mid'])
                      ->where(['remisor' => $session->get('__tercero')])
                      ->andWhere(['visto' => '0'])
                      ->count();

                  echo $mensajes != 0 ? '<span class="info-label warning-bg">'.$mensajes.'</span>' : '';    
              ?>
          </li>

          <li class="list-box dropdown">
            <a id="drop5" href="#" role="button" class="dropdown-toggle" data-toggle="dropdown" style="padding: 10px;">
              <i class="fa fa-bell"></i>
            </a>
            <!--<span class="info-label success-bg">6</span>-->
            <ul class="dropdown-menu server-activity">
            <!--
              <li>
                <p><i class="fa fa-flag text-info"></i> Pending request<span class="time">3 hrs</span></p>
              </li>
              <li>
                <p><i class="fa fa-fire text-warning"></i> Server Crashed<span class="time">3mins</span></p>
              </li>
              <li>
                <p><i class="fa fa-bell text-danger"></i>9 pending requests<span class="time">5 min</span></p>
              </li>
              <li>
                <p><i class="fa fa-plane text-info"></i> Performance<span class="time">25 min</span></p>
              </li>
              <li>
                <p><i class="fa fa-cog icon-spin text-success"></i> Location settings<span class="time">4 hrs</span></p>
              </li>
            -->
            
              <li>
                <p><i class="fa fa-user text-danger"></i> Ausentismo

                  <?php
                     $actual = Asistencia::find()
                      ->select(['COUNT(estudiante) AS fallas'])
                      ->where(['DATE(fecha)' => new Expression('CURDATE()')])
                      ->orderby('estudiante')
                      ->one();
                  ?> 
                <span class="time text-danger"><?= $actual->fallas ?></span>
                </p>
              </li>
              <li>
                <p><i class="fa fa-envelope text-warning"></i>Mensajes nuevos hoy
                  <?php
                     $mensajes = Mensajes::find()
                      ->select(['COUNT(mensaje) as mid'])
                      ->where(['DATE(creado_el)' => new Expression('CURDATE()'), 'creado_por' => Yii::$app->session->get('__tercero')])
                      ->one();
                  ?> 
                  
                  <span class="time"><?= $mensajes->mid ?></span></p>
              </li>
              
            </ul>
          </li>

          

          <li class="list-box user-profile">
            <a id="drop7" href="#" role="button" class="dropdown-toggle user-avtar" data-toggle="dropdown">
              <?= Html::img($user->foto ? '@web/uploads/thumbnail/sm-'.$user->foto : '@web/images/user.jpg', ['class'=>'img-circle img-responsive']); ?>
            </a>
            <ul class="dropdown-menu server-activity">
              <li>
                <p><i class="fa fa-user text-info"></i> 
                  <?= ($doc != 'admin') ? $user->nombre : 'SONIC'; ?>
                </p>
              </li>
              <li>
                <p>
                    <i class="fa fa-user-tag text-warning"></i><?= ($session->isActive) ? $user->tipoterceros->tipo : '' ?> 
                    <? 
                        if (($session->isActive) AND (Yii::$app->session->get('__tipo') == 1) AND ($doc != 'admin'))
                        {
                            //echo 'Grupo '.isset($user->grupo) ? $user->grupo->grupo : '';
                        } 
                    ?>
                </p>
              </li>
              <li>
                <p><i class="fa fa-lock text-danger"></i><?= Html::a(Yii::t('app', 'Cambiar Contraseña'),false,['value' => Url::to(['user/password']), 'title' => Yii::t('app', 'Cambiar Contraseña'), 'class' => 'showModalButton', 'style' => 'padding: 0px !important; line-height: 18px; display: inline; color: #000;']) ?></p>
              </li>

              <li>
                <p>
                    <i class="fa fa-clock text-primary"></i>
                    <span class="badge badge-warning"><?= Yii::t('app', 'Vigencia').' '.$sede->vigencia ?></span>
                    <span class="badge badge-success"><?= $periodo->actual->periodo ?></span>
                </p>
              </li>
              
              <li>
                <div class="demo-btn-group clearfix">
                    
                    <?= Html::a(
                            'Cerrar sesión en Sonic <i class="fas fa-sign-out-alt"></i>',
                            ['/site/logout'],
                            [
                              'class' => 'btn btn-primary',
                              'style' => 'padding:6px 12px !important; width:100%; color:#fff;',
                              'data-method' => 'post',
                            ]
                        ) ?>

                </div>
              </li>
            </ul>
          </li>
        </ul>
      </div>
    </header>
    <!-- Header End -->

    
    <!-- Main Container start -->
    <div class="dashboard-container">

      <div class="container">


        <!-- Top Nav Start -->
        <div id='cssmenu'>

            <?php
                if ($session->isActive) 
                {    

                  if(Yii::$app->session->get('__tipo') == 1)
                  {

                    $manuales = [
                            [
                              'label' => '<img src="https://www.ivanacosta.com/sonicapp/images/menu/asignatura.png" class="img-menu">Asignaturas', 
                              'url' => ['reporte504/index', 'tercero' => Yii::$app->session->get('__tercero')],
                            ],
                            [
                                'label' => '<img src="https://www.ivanacosta.com/sonicapp/images/menu/academico.png" class="img-menu">Boletín', 
                                'url' => ['reporte703/index', 'tercero' => Yii::$app->session->get('__tercero')],
                            ],
                            [
                                'label' => '<img src="https://www.ivanacosta.com/sonicapp/images/menu/asistencia.png" class="img-menu">Ausentismo', 
                                'url' => ['reporte103/index', 'tercero' => Yii::$app->session->get('__tercero')],
 
                            ],
                            [
                                'label' => '<img src="https://www.ivanacosta.com/sonicapp/images/menu/observador.png" class="img-menu">Observaciones', 
                                'url' => ['reporte104/index', 'tercero' => Yii::$app->session->get('__tercero')],
 
                            ],
                            [
                                'label' => '<img src="https://www.ivanacosta.com/sonicapp/images/menu/reportes.png" class="img-menu">Certificados', 
                                'url' => '#',
                                'items' => [
                                              /*[
                                                'label' => 'Notas', 
                                                'url' => ['route']
                                              ],*/
                                              [
                                                'label' => 'Matricula', 
                                                'url' => ['tercero/hojadevida', 'id' => Yii::$app->session->get('__tercero')]
                                              ],
                                              [
                                                'label' => 'Certificado Cofrem', 
                                                'url' => ['reporte107/index', 'tercero' => Yii::$app->session->get('__tercero')]
                                              ],
                                              [
                                                'label' => 'Familias en Acción', 
                                                'url' => ['reporte108/index', 'tercero' => Yii::$app->session->get('__tercero')]
                                              ],/*
                                              [
                                                'label' => 'Policia', 
                                                'url' => ['route']
                                              ],*/
                                ]
                            ],
                        ];

                    $asignados = MenuHelper::getAssignedMenu(Yii::$app->user->id);

                    $items = ArrayHelper::merge($asignados, $manuales);
                  }
                  else
                  {
                    $items = MenuHelper::getAssignedMenu(Yii::$app->user->id);;
                  }  
                   echo Menu::widget([
                            'options' => ['class' => 'principal no-print', 'id' => ''],
                            'items' => $items,
                            'encodeLabels' => false, //allows you to use html in labels
                            'activateParents' => true,
                            'activateItems' => true,
                            'activeCssClass' => 'active',
                            'linkTemplate' => '<a href="{url}"><span>{label}</span></a>', 
                            'submenuTemplate' => "\n<ul class='secundario'>\n{items}\n</ul>\n",
                            ]);
                } 
            ?>

        </div>

        <!-- Top Nav End -->

        <!-- Sub Nav End -->
        <div class="sub-nav">
          <ul class="hidden-sm hidden-xs">
            <li><a href="" class="heading">
                <?php
                    if ($this->title !== null) {
                        echo \yii\helpers\Inflector::camel2words($this->title).' <i class="ace-icon fa fa-angle-double-right"></i>';
                    } else {
                        echo \yii\helpers\Inflector::camel2words(\yii\helpers\Inflector::id2camel($this->context->module->id));
                        echo ($this->context->module->id !== \Yii::$app->id) ? '<i class="ace-icon fa fa-angle-double-right"></i><small>Módulo</small>' : '';
                    } 
                ?>
                </a>
            </li>
            
            </ul>
            <?= Breadcrumbs::widget([
                  'options' => ['class' => 'hidden-sm hidden-xs'], 
                  'activeItemTemplate' => "<li class='hidden-sm hidden-xs'><a href='#' class='selected'>{link}</a></li>\n",  
                  'itemTemplate' => "<li>{link}</li>\n",  
                  'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
               ]) 
            ?>
          
          <div class="custom-options">
            <?= Actions::widget([
                  'links' => isset($this->params['actions']) ? $this->params['actions'] : [],
               ]) 
            ?>
          </div>
        </div>
        <!-- Sub Nav End -->

        <!-- Dashboard Wrapper Start -->
        <div class="dashboard-wrapper-lg">

            <?= Alert::widget() ?>

            <?= $content ?>

        </div>
      <!-- Dashboard Wrapper End -->  

      </div>

      
    </div>
    <!-- Main Container end -->
   
    <footer>
      <p>© Sonic | Software de Notas Integrado para Colegios <span class="label label-warning"> <?= Yii::getVersion(); ?></span></p> 
    </footer>