<?php

/* @var $this \yii\web\View */
/* @var $content string */

use backend\assets\AppAsset;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\Modal;

$asset = backend\assets\AppAsset::register($this);
$baseUrl = $asset->baseUrl;

$this->registerJs("
    $(document).on('select2:open', (e) => {
        var id = e.target.id
        document.querySelector('.select2-search__field').focus();
    });
");


if (!Yii::$app->user->isGuest) {

$this->registerJs("
            var goLockScreen = false;
            var stop = false;
            var autoLockTimer;
            window.onload = resetTimer;
            window.onmousemove = resetTimer;
            window.onmousedown = resetTimer; // catches touchscreen presses
            window.onclick = resetTimer;     // catches touchpad clicks
            window.onscroll = resetTimer;    // catches scrolling with arrow keys
            window.onkeypress = resetTimer;
 
            function lockScreen() {
                stop = true;

                window.location.href = '".\yii\helpers\Url::toRoute(['/site/lock-screen'])."?previous='+encodeURIComponent(window.location.href);
                //window.location.href = '".\yii\helpers\Url::toRoute(['/site/lock-screen'])."';
            }
             
            function lockIdentity(){
                goLockScreen = true;
                lockScreen();
            }
             
            function resetTimer() {
                if(stop==true){
                 
                }
                else if (goLockScreen) {
                    lockScreen();               
                }
                else{
                    clearTimeout(autoLockTimer);
                    autoLockTimer = setTimeout(lockIdentity, 1000*60*50);  // 5 Minutos - Tiempo en milisegundos
                }
                     
            }
        ");
}


$this->registerJs("
    $(document).ready(function(){        
        var originalSize = $('div,p,span,a,small,h1,h2,h3,h4,h5,th,td').css('font-size');         
        // reset        
        $('.resetMe').click(function(){ 
            $('div,p,span,a,small,h1,h2,h3,h4,h5,th,td').css('font-size', originalSize);         
        });

        // Increase Font Size          
        $('.increase').click(function(){         
            var currentSize = $('div,p,span,a,small,h1,h2,h3,h4,h5,th,td').css('font-size');         
            var currentSize = parseFloat(currentSize)+1;          
            $('div,p,span,a,small,h1,h2,h3,h4,h5,th,td').css('font-size', currentSize);         
            return false;          
        });        

        // Decrease Font Size       
        $('.decrease').click(function(){        
            var currentFontSize = $('div,p,span,a,small,h1,h2,h3,h4,h5,th,td').css('font-size');        
            var currentSize = $('div,p,span,a,small,h1,h2,h3,h4,h5,th,td').css('font-size');        
            var currentSize = parseFloat(currentSize)-1;        
            $('div,p,span,a,small,h1,h2,h3,h4,h5,th,td').css('font-size', currentSize);         
            return false;         
        }); 

        $('.zoom-in').click(function() {
           updateZoom(0.1);
        });

        $('.zoom-out').click(function() {
           updateZoom(-0.1);
        });


        zoomLevel = 1;

        var updateZoom = function(zoom) {
           zoomLevel += zoom;
           $('body').css({ zoom: zoomLevel, '-moz-transform': 'scale(' + zoomLevel + ')' });
        }        
    });
    
");


AppAsset::register($this);
          

$this->registerJs("
    $(function() {
        $(\"[data-toggle='popover']\").popover();
    });
    
    $('[data-toggle=\"popover\"]').popover();
    
    $(function() {
        $(\"[data-toggle='tooltip']\").tooltip();
    });

    //$('#modal').removeAttr('tabindex');
");


$this->registerJs("
      //ScrollUp
      $(function () {
        $.scrollUp({
          scrollName: 'scrollUp', // Element ID
          topDistance: '300', // Distance from top before showing element (px)
          topSpeed: 300, // Speed back to top (ms)
          animation: 'fade', // Fade, slide, none
          animationInSpeed: 400, // Animation in speed (ms)
          animationOutSpeed: 400, // Animation out speed (ms)
          scrollText: '<i class=\"fa fa-arrow-up\" aria-hidden=\"true\"></i>', // Text for element
          activeOverlay: false, // Set CSS color to display scrollUp active point, e.g '#00FFFF'
        });
      });
");


if (Yii::$app->controller->action->id === 'login' or Yii::$app->controller->action->id === 'lock-screen' or Yii::$app->controller->action->id === 'request-password-reset' or Yii::$app->controller->action->id === 'reset-password') {
    echo $this->render(
        'wrapper-black',
        ['content' => $content]
    );
} else {

?>
<?php $this->beginPage() ?>

<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">


      <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
      <![endif]-->

    <?= Html::csrfMetaTags() ?>
    
<!--
    <link rel="shortcut" href="<?= $baseUrl?>/favicon.png" type="image/png">
-->

    <link rel="apple-touch-icon" sizes="180x180" href="<?= $baseUrl?>/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?= $baseUrl?>/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?= $baseUrl?>/favicon-16x16.png">
    <link rel="manifest" href="<?= $baseUrl?>/site.webmanifest">
    <link rel="mask-icon" href="<?= $baseUrl?>/safari-pinned-tab.svg" color="#5bbad5">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="theme-color" content="#ffffff">



    <!-- Start of  Zendesk Widget script 
    <script id="ze-snippet" src="https://static.zdassets.com/ekr/snippet.js?key=7d38157b-e2fb-413f-a503-844c41019ce0"> </script>
    <!-- End of  Zendesk Widget script -->

    <title><?= Html::encode(strip_tags($this->title)) ?></title>

<?php $this->head() ?>


</head>


<body>


<?php
    
    Modal::begin([
        'headerOptions' => ['id' => 'modalHeader'],
        'id' => 'modal',
        'header' => 'Sonic',
        'size' => 'modal-lg',
        
        //keeps from closing modal with esc key or by clicking out of the modal.
        // user must click cancel or X to close
        //'clientOptions' => ['backdrop' => 'static', 'keyboard' => TRUE, 'show' => FALSE, 'tabindex'=>'-1']
        'clientOptions' => ['backdrop' => 'static', 'keyboard' => TRUE, 'show' => FALSE]
    ]);
?>    
    <div id='modalContent'>
        <div style='text-align:center;'>
            <img src='<?= Url::to('@web/images/loading.gif')?>' width='50px' height='50px'>
        </div>
    </div>
<?php    
    yii\bootstrap\Modal::end();
?>

    <!-- Loading start -->
        <div id="loading-wrapper">
            <div id="loader"></div>
        </div>
    <!-- Loading end -->

    <div id="flotante" class="btn-group-vertical btn-group btn-group-xs">
        <button type="button" class="increase btn btn-success"><i class="fas fa-plus" style="font-size: 8px;"></i></button>
        <button type="button" class="resetMe btn btn-default"><i class="fas fa-equals" style="font-size: 8px;"></i></button>
        <button type="button" class="decrease btn btn-danger"><i class="fas fa-minus" style="font-size: 8px;"></i></button>
    </div>

<?php $this->beginBody() ?>

        <?= $this->render('content',['content' => $content,'baseUrl' => $baseUrl]) ?>

<?php

    if (Yii::$app->controller->action->id === 'create' 
        or Yii::$app->controller->action->id === 'update' 
        or Yii::$app->controller->action->id === 'calificaciones'
        or Yii::$app->controller->action->id === 'nivelaciones' 
        or Yii::$app->controller->action->id === 'area' 
        or Yii::$app->controller->action->id === 'asistencia'
        or Yii::$app->controller->id === 'parametros' ) 
    {
        echo $this->render('form',['baseUrl' => $baseUrl]);
    } 
?>  

<?php $this->endBody() ?>

<script type="text/javascript">
    $.fn.modal.Constructor.prototype.enforceFocus = function() {};
    <!--$.fn.modal.Constructor.prototype._enforceFocus = function() {};-->
</script>

</body>
</html>
<?php $this->endPage() ?>
<?php } ?>

