<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Religion */
/* @var $form yii\widgets\ActiveForm */

\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Tercero', 
        'relID' => 'tercero', 
        'value' => \yii\helpers\Json::encode($model->terceros),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);
?>

<div class="religion-form">

    <?php 

        $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                            'id' => 'formulario',
                        ]
        ]); 
    ?>
    
    <?= $form->errorSummary($model); ?>

    <?= $form->field($model, 'religion')->textInput(['maxlength' => true, 'placeholder' => 'Religion']) ?>

    <div class="form-group" id="add-tercero"></div>

    <?php ActiveForm::end(); ?>

</div>
