<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Matricula */

$this->title = $model->estudiantes->nombre;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Matricula'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="matricula-view">

    <div class="row">
        <div class="col-sm-9">
            <h4><?= Html::encode($this->title) ?></h4>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
<?=             
             Html::a('<i class="fa glyphicon glyphicon-hand-up"></i> ' . Yii::t('app', 'PDF'), 
                ['pdf', 'id' => $model->id],
                [
                    'class' => 'btn btn-danger',
                    'target' => '_blank',
                    'data-toggle' => 'tooltip',
                    'title' => Yii::t('app', 'Will open the generated PDF file in a new window')
                ]
            )?>
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'estudiantes.nombre',
            'label' => Yii::t('app', 'Estudiante'),
        ],
        [
            'attribute' => 'grupos.grupo',
            'label' => Yii::t('app', 'Grupo'),
        ],
        [
            'attribute' => 'especialidades.especialidad',
            'label' => Yii::t('app', 'Especialidad'),
        ],
        'fecha_matricula',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    <div class="row">
        <h4>Información del Estudiante</h4>
    </div>
    <?php 
    $gridColumnTercero = [
        ['attribute' => 'id', 'visible' => false],
        'identificacion',
        'tipo',
        'departamento_expedido',
        'municipio_expedido',
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        'genero',
        'tipo_tercero',
        'fecha_nacimiento',
        'departamento_nacimiento',
        'municipio_nacimiento',
        'pais',
        'rh',
        'religion',
        'etnia',
        'eps',
        'direccion',
        'departamento_residencia',
        'municipio_residencia',
        'barrio',
        'fijo',
        'movil',
        'email',
        'foto',
        'firma',
        'estrato',
        'situacion',
        'codigo_desplazado',
        'departamento_desplazado',
        'municipio_desplazado',
        'codigo_sisben',
        'codigo_familia_accion',
        'capacidad',
        'medicamentos',
        'alergias',
        'discapacidad',
        'discapacidad_certificada',
        'subsidio',
        'recurso',
        'bienestar',
        'heroe',
        'fuerza_publica',
        'sector',
        'resguardo',
        'departamento_resguardo',
        'cabeza_familia',
        'activo',
        [
            'attribute' => 'estados.estado',
            'label' => Yii::t('app', 'Estado'),
        ],
        'bloqueo',
    ];
    echo DetailView::widget([
        'model' => $model->estudiantes,
        'attributes' => $gridColumnTercero    ]);
    ?>
    <div class="row">
        <h4>Información del Grupo</h4>
    </div>
    <?php 
    $gridColumnGrupo = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'director',
        'jornada',
        'sede',
        'metodologia',
        'modalidad',
        [
            'attribute' => 'especialidades.especialidad',
            'label' => Yii::t('app', 'Especialidad'),
        ],
    ];
    echo DetailView::widget([
        'model' => $model->grupos,
        'attributes' => $gridColumnGrupo    ]);
    ?>
    <div class="row">
        <h4>Informacion de la Especialidad</h4>
    </div>
    <?php 
    $gridColumnEspecialidad = [
        ['attribute' => 'id', 'visible' => false],
        'especialidad',
    ];
    echo DetailView::widget([
        'model' => $model->especialidades,
        'attributes' => $gridColumnEspecialidad    ]);
    ?>
</div>
