
<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use kartik\widgets\Select2;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use backend\models\Tercero;
use backend\models\Academico;
use backend\models\Asistencia;
use yii\db\Expression;


$this->registerCss('
	/* PIN BOARD */
	ul.notes {
		margin: auto auto; 
	}
	ul.notes li,
	ul.tag-list li {
	  list-style: none;
	}
	ul.notes li h4 {
	  margin-top: 20px;
	  font-size: 16px;
	}
	ul.notes li div {
	  text-decoration: none;
	  color: #000;
	  background: #ffc;
	  display: block;
	  height: 140px;
	  width: 140px;
	  padding: 1em;
	  position: relative;
	}
	ul.notes li div small {
	  position: absolute;
	  top: 5px;
	  right: 5px;
	  font-size: 10px;
	}
	.borrar {
	  position: absolute;
	  right: 10px;
	  bottom: 10px;
	  color: inherit;
	}

	ul.notes li div a img{
	  max-width: 38px !important;
	  height: auto;
	}

	ul.notes li {
	  margin: 10px 40px 50px 40px;
	  float: left;
	}
	ul.notes li div p {
	  font-size: 12px;
	}
	ul.notes li div {
	  text-decoration: none;
	  color: #000;
	  background: #ffc;
	  display: block;
	  height: 140px;
	  width: 140px;
	  padding: 1em;
	  word-wrap: break-word;
	  overflow: hidden;
	  /* Firefox */
	  -moz-box-shadow: 5px 5px 2px #212121;
	  /* Safari+Chrome */
	  -webkit-box-shadow: 5px 5px 2px rgba(33, 33, 33, 0.7);
	  /* Opera */
	  box-shadow: 5px 5px 2px rgba(33, 33, 33, 0.7);
	}
	ul.notes li div {
	  -webkit-transform: rotate(-6deg);
	  -o-transform: rotate(-6deg);
	  -moz-transform: rotate(-6deg);
	  -ms-transform: rotate(-6deg);
	}
	ul.notes li:nth-child(even) div {
	  -o-transform: rotate(4deg);
	  -webkit-transform: rotate(4deg);
	  -moz-transform: rotate(4deg);
	  -ms-transform: rotate(4deg);
	  position: relative;
	  top: 5px;
	}
	ul.notes li:nth-child(3n) div {
	  -o-transform: rotate(-3deg);
	  -webkit-transform: rotate(-3deg);
	  -moz-transform: rotate(-3deg);
	  -ms-transform: rotate(-3deg);
	  position: relative;
	  top: -5px;
	}
	ul.notes li:nth-child(5n) div {
	  -o-transform: rotate(5deg);
	  -webkit-transform: rotate(5deg);
	  -moz-transform: rotate(5deg);
	  -ms-transform: rotate(5deg);
	  position: relative;
	  top: -10px;
	}
	ul.notes li div:hover,
	ul.notes li div:focus {
	  -webkit-transform: scale(1.1);
	  -moz-transform: scale(1.1);
	  -o-transform: scale(1.1);
	  -ms-transform: scale(1.1);
	  position: relative;
	  z-index: 5;
	}
	ul.notes li div {
	  text-decoration: none;
	  color: #000;
	  background: #ffc;
	  display: block;
	  height: 210px;
	  width: 210px;
	  padding: 1em;
	  -moz-box-shadow: 5px 5px 7px #212121;
	  -webkit-box-shadow: 5px 5px 7px rgba(33, 33, 33, 0.7);
	  box-shadow: 5px 5px 7px rgba(33, 33, 33, 0.7);
	  -moz-transition: -moz-transform 0.15s linear;
	  -o-transition: -o-transform 0.15s linear;
	  -webkit-transition: -webkit-transform 0.15s linear;
	}
');

?>


<script type="text/javascript">
    
    function borrar_nota(id)
    {
    	//alert(id);

      swal({
          title: '¿Deseas eliminar la nota?',
          text: 'Deseas cambiar eliminar la nota de la cartelera, recuerda que podrás verla en el modulo de mensajes.',
          type: 'warning',
          showCancelButton: true,
          confirmButtonClass: 'btn-warning',
          confirmButtonText: 'Si, estoy seguro!',
          cancelButtonText: 'No, Cancelar',
          closeOnConfirm: false,
          closeOnCancel: false
        },
        function(isConfirm) {
          if (isConfirm) 
          {
            $.ajax({
                    type: 'GET',
                    url: '<?= Url::to(["mensajes/deletenota"]) ?>',
                    data: {id : id},
                    success: function (data) {
                        swal({
                            title: 'Enhorabuena!',
                            text: 'Hemos eliminado la nota satisfactoriamente.',
                            type: 'success',
                            allowOutsideClick: false,
                            timer: 3000,
                        });

                        $("#" + id).fadeOut(400);
                    }
            });  
          } 
          else 
          {
              swal({
                title: 'Cancelado!',
                text: 'Haz cancelado eliminar la nota.',
                type: 'error',
                timer: 3000})
          }
      }); 
    }  

</script>

<div class="row gutter">
  <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <div class="ibox ">
        <div class="ibox-title">
            <h5><?= Yii::t('app', 'Cartelera') ?></h5>
            <div class="ibox-tools">
                <a class="collapse-link">
                    <i class="fa fa-chevron-up"></i>
                </a>
                <a class="close-link">
                    <i class="fa fa-times"></i>
                </a>
            </div>
        </div>
        <div class="ibox-content">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12"> <!--  CONTENIDO -->
                  
                  <div class="row">
						<div class="col-lg-12">
						    <ul class="notes">
						    	<? foreach ($carteleras as $cartelera) { ?>
						    		
						    	
						        <li id="<?= $cartelera->id ?>">
						            <div style="background-color: <?= $cartelera->categorias->color; ?>;">
						                <small><?= Yii::$app->formatter->asDate($cartelera->creado_el, 'long') ?></small>
						                <h4><?= $cartelera->asunto ?></h4>
						                <p><?= $cartelera->mensaje ?></p>
						                <!--<a class="borrar" href="#"><i class="far fa-trash-alt"></i></a>-->
						                <? Html::a('<i class="far fa-trash-alt"></i>', false, [ 'title' => 'Eliminar', 'class' => 'borrar', 'id' => $cartelera->id, 'onClick' => 'borrar_nota($cartelera->id);']); ?> 

						                <?= Html::button('<i class="far fa-trash-alt"></i>', [ 'class' => 'btn btn-link borrar', 'onclick' => 'borrar_nota('.$cartelera->id.');' ]); ?>
						            </div>
						        </li>
						        <? } ?>
						    </ul>
						</div>
					</div>

                </div> <!--  FIN  CONTENIDO -->
            </div>
        </div>
    </div>
  </div>
</div>