<?php

use yii\helpers\Html;
use backend\models\base\Mensajescategorias;
use backend\models\base\Mensajes;

?>
<div class="ibox float-e-margins">
    <div class="ibox-content mailbox-content">
        <div class="file-manager">

            <?= Html::a('Redactar', ['create'], ['class'=>'btn btn-block btn-primary compose-mail']) ?>

            <div class="space-25"></div>
            <br>
            <ul class="folder-list m-b-md" style="padding: 0">
                
                <li>
                    <?
                        $recibidos = Mensajes::find()->where(['remisor' => Yii::$app->session->get('__tercero'), 'visto' => '0'])->count();

                        if ($recibidos != '0')
                            $recibidos = '<span class="label label-warning pull-right">'.$recibidos.'</span>';
                        else
                            $recibidos = '';
                    ?>
                    <?= Html::a('<i class="far fa-inbox"></i> Recibidos '.$recibidos, ['index'], []) ?>
                </li>
                <li>
                    <?= Html::a('<i class="far fa-envelope"></i> Enviados', ['enviados'], []) ?>
                </li>
                <li>
                    <?
                        $importantes = Mensajes::find()->where(['remisor' => Yii::$app->session->get('__tercero'), 'visto' => '0','importante' => '1'])->count();

                        if ($importantes != '0')
                            $importantes = '<span class="label label-primary pull-right">'.$importantes.'</span>';
                        else
                            $importantes = '';
                    ?>
                    <?= Html::a('<i class="far fa-certificate"></i> Importantes '.$importantes, ['importantes'], []) ?>
                </li>
                
                <li>
                    <?
                        $eliminados = Mensajes::find()->where(['remisor' => Yii::$app->session->get('__tercero'),'estado' => '0'])->count();

                        if ($eliminados != '0')
                            $eliminados = '<span class="label label-danger pull-right">'.$eliminados.'</span>';
                        else
                            $eliminados = '';
                    ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i> Eliminados '.$eliminados, ['eliminados'], []) ?>
                </li>
            </ul>
            <br>
            <ul class="category-list" style="padding: 0">
                <?
                    $categorias = Mensajescategorias::find()->all();

                    foreach ($categorias as $categoria) {
                        echo "<li>";
                        echo Html::a('<i class="fa fa-circle" style="color:'.$categoria->color.';"></i> '.$categoria->categoria, ['index', 'categoria' =>$categoria->id], []);
                        echo "</li>";
                    }
                ?>    
                
            </ul>
            <div class="clearfix"></div>
        </div>
    </div>
</div>
