<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use backend\models\Tercero;
use kartik\widgets\DatePicker;

// Remitente  = De
// Remisor = Para

?>


<div class="row">

    <div class="col-sm-2">
        <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive']); ?>
    </div>    
    
    <div class="col-sm-10">

        <?php $form = ActiveForm::begin([
            'action' => ['index'],
            'method' => 'get',
        ]); ?>

        <div class="col-sm-6">

            <?= $form->field($model, 'remitente')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->orderBy('id')->asArray()->all(), 'id', 'nombre'),
                'options' => ['placeholder' => 'De'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(false); ?>

        </div>

        <div class="col-sm-6">

            <?= $form->field($model, 'asunto')->textInput(['maxlength' => true, 'placeholder' => 'Asunto'])->label(false) ?>

        </div>
        
        <div class="col-sm-6">

            <?= $form->field($model, 'mensaje')->textInput(['placeholder' => 'Mensaje'])->label(false); ?>

        </div>

        <div class="col-sm-6">

            <?= $form->field($model, 'categoria')->widget(\kartik\widgets\Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\MensajesCategorias::find()->orderBy('id')->asArray()->all(), 'id', 'categoria'),
                'options' => ['placeholder' => 'Categoría'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(false); ?>

        </div>
        

        
        <!--
        <div class="col-sm-2">

            <?= $form->field($model, 'importante')->checkBox(['label'=>'Es Importante?', 'class' => 'i-checks']); ?>

        </div>
        
        <div class="col-sm-6">


            <?php /* echo $form->field($model, 'adjunto')->textarea(['rows' => 6]) */ ?>

        </div>
        <div class="col-sm-6">


            <?php /* echo $form->field($model, 'visto')->textInput(['placeholder' => 'Visto']) */ ?>

        </div>
        <div class="col-sm-6">


            <?php /* echo $form->field($model, 'visto_el')->widget(\kartik\datecontrol\DateControl::classname(), [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Visto El',
                        'autoclose' => true,
                    ]
                ],
            ]); */ ?>

        </div>-->
        <div class="col-sm-6">
            <?= $form->field($model, 'creado_el')->widget(DatePicker::classname(), [
                    'options' => ['placeholder' => 'Fecha'],
                    'pluginOptions' => [
                        'autoclose' => true,
                        'format' => 'yyyy-mm-dd',
                        'todayHighlight' => true,            ]
                ])->label(false) ?>
        </div>
        
        <!--
        <div class="col-sm-6">


            <?php /* echo $form->field($model, 'creado_por')->textInput(['placeholder' => 'Creado Por']) */ ?>

        </div>
        <div class="col-sm-6">


            <?php /* echo $form->field($model, 'actualizado_el')->widget(\kartik\datecontrol\DateControl::classname(), [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Actualizado El',
                        'autoclose' => true,
                    ]
                ],
            ]); */ ?>

        </div>
        <div class="col-sm-6">


            <?php /* echo $form->field($model, 'actualizado_por')->textInput(['placeholder' => 'Actualizado Por']) */ ?>

        </div>
        <div class="col-sm-6">


            <?php /* echo $form->field($model, 'estado')->textInput(['placeholder' => 'Estado']) */ ?>

        </div>
    -->
        <div class="col-sm-6">

            <div class="form-group">
                <?= Html::submitButton('<i class="fa fa-search" aria-hidden="true"></i> Buscar', ['class' => 'btn btn-primary']) ?>
                <?= Html::resetButton('<i class="fa fa-eraser" aria-hidden="true"></i> Limpiar', ['class' => 'btn btn-danger']) ?>
                
                <?= Html::a('<i class="fa fa-inbox" aria-hidden="true"></i> Volver a Recibidos', ['index'], ['class'=>'btn btn-default']) ?>
            </div>
        </div>    
        <?php ActiveForm::end(); ?>
    </div>
</div>
