<?php
########################################################
#                                                      #
#               GOOD SOLUTIONS COLOMBIA                #
#            www.gsol.co - contacto@gsol.co            #
#                     GSOL Colombia                    #
#                   N.I.T 900065739-7                  #
########################################################

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\widgets\ActiveForm;
use \yii\helpers\ArrayHelper;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;
use dosamigos\tinymce\TinyMce;


use backend\models\Tercero;
use backend\models\Tipotercero;
use backend\models\Grupo;




$this->title = 'Redactar';
$this->params['breadcrumbs'][] = ['label' => 'Mensajes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Enviar', 'url' => false, 'action' => 'guardar', 'icon' => '<i class="far fa-envelope"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Cancelar', 'url' => ['index'], 'icon' => '<i class="far fa-times"></i>', 'class' => 'danger'];


$this->registerJs("
    $(document).ready(function(){
        $('.i-checks').iCheck({
            checkboxClass: 'icheckbox_square-green',
            radioClass: 'iradio_square-green',
        });
    });
");


?>

<div class="row">
    <div class="col-lg-2">
        <?= $this->render('_panel',['model' => $model]) ?>
    </div>
    
    <div class="col-lg-10">
	
		<div class="mail-box-header">
        	<h3>
            	Redactar Mensaje
        	</h3>
    	</div>
        <div class="mail-box">
        	<div class="mail-body">

			    <?php $form = ActiveForm::begin([
		            'validateOnSubmit' => true,
		            'type' => ActiveForm::TYPE_VERTICAL,
		            'options' => ['class' => 'form-horizontal',
		                          'id' => 'formulario',
		                          'enctype'=>'multipart/form-data',
		                        ]
		        ]); ?>	


			    <?= $form->errorSummary($model); ?>

			    <div class="form-group">
			    	
			    	<label class="col-sm-1 control-label">Para:</label>
                    
                    <div class="col-sm-5">

					    <?= $form->field($model, 'tipo')->widget(Select2::classname(), [
				            'data' => ArrayHelper::map(Tipotercero::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
				            'options' => ['id'=>'tipo-id', 'placeholder' => 'Seleccione el Tipo de Destinatario',],
				            'pluginOptions' => [
				                'allowClear' => true,
				            ],
				        ])->label(false) ?>

				    </div>
			        <div class="col-sm-6">

				        <?= $form->field($model, 'grupo')->widget(DepDrop::classname(), [
				            //'data' => ArrayHelper::map(Grupo::find()->orderBy('id')->asArray()->all(), 'id', 'grupo'),
				            'type'=>DepDrop::TYPE_SELECT2,
				            'options'=>['id'=>'grupo-id', 'placeholder'=>'Seleccione como Enviarlo'],
				            'pluginOptions'=>[
				                'multiple' => true,
				                'depends'=>['tipo-id'],
				                'url'=>Url::to(['findxgrupo']),
				            ]
				        ])->label(false);
				        ?>

		        	</div>
                </div>

                <div class="form-group">
                	
                	<label class="col-sm-1 control-label">&nbsp;</label>
                    
                    <div class="col-sm-11">

					    <?= $form->field($model, 'remisor')->widget(DepDrop::classname(), [
				            //'data' => ArrayHelper::map(Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['tipo_tercero' => '1'])->andWhere(['<', 'estado', '3'])->orderBy('id')->asArray()->all(), 'id', 'nombre'),
				            'type'=>DepDrop::TYPE_SELECT2,
				            'options' => ['multiple' => true,'id'=>'remisor'],
        					'select2Options'=>['options' => ['multiple' => true],'pluginOptions'=>['allowClear'=>true,'placeholder'=>'Seleccione el Grupo o los Destinatarios',]],
        
				            'pluginOptions'=>[
				                
				                'depends'=>['tipo-id','grupo-id'],
				                'url'=>Url::to(['finddestinatarios']),
				            ]
				        ])->label(false);
				        ?>
					
					</div>
				</div>
				<div class="form-group">

					<label class="col-sm-1 control-label">Asunto:</label>

					<div class="col-sm-11">

						<?= $form->field($model, 'asunto')->textInput(['maxlength' => true, 'placeholder' =>'Asunto'])->label(false); ?>
				
					</div>
				</div>
				
				<div class="form-group">
					
					<label class="col-sm-1 control-label">Categoría:</label>
					
					<div class="col-sm-5">

					   	<?= $form->field($model, 'categoria')->widget(\kartik\widgets\Select2::classname(), [
					        'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\MensajesCategorias::find()->orderBy('id')->asArray()->all(), 'id', 'categoria'),
					        'options' => ['placeholder' => 'Seleccione la Categoría'],
					        'pluginOptions' => [
					            'allowClear' => true
					        ],
					    ])->label(false); ?>

					</div>

					<div class="col-sm-3">
					    <?= $form->field($model, 'importante')->checkBox(['label'=>'Es Importante?', 'class' => 'i-checks']); ?>
					</div>
					<div class="col-sm-3">
						<?
							if(Yii::$app->session->get('__tipo') != 1)
							{
								echo $form->field($model, 'cartelera')->checkBox(['label'=>'Poner en Cartelera?', 'class' => 'i-checks']);
							}
						?>
					</div>
				</div>


				<div class="form-group">
					
					<div class="col-sm-12">
				
						<?= $form->field($model, 'mensaje')->widget(TinyMce::className(), [
						    'options' => ['rows' => 15],
						    'language' => 'es',
						    'clientOptions' => [
						        'plugins' => [
						            "advlist autolink lists link charmap print preview anchor",
						            "searchreplace visualblocks code fullscreen",
						            "insertdatetime media image table contextmenu paste"
						        ],
						        'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
						    ]
						])->label(false);?>

				    </div>
			    </div>

				<div class="form-group">
					
					<div class="col-sm-12">

					    <?= $form->field($model, 'adjunto[]')->widget(FileInput::classname(), [
				            'options' => ['multiple'=>true],
				            'pluginOptions'=>[
				            	//'uploadUrl' => Url::to(['/site/file-upload']),
				                //'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp','pdf','doc', 'docx','xls'],
				            	'previewFileType' => 'any',
				                'showUpload' => false,
				                'overwriteInitial' => false,
				                'browseClass' => 'btn btn-primary',
				                'uploadClass' => 'btn btn-success',
				                'removeClass' => 'btn btn-danger',
				                'removeIcon' => '<i class="glyphicon glyphicon-trash"></i>',
				                ],
				        ])->label('Adjuntos:'); ?>
					
					</div>
				</div>

			    <?php ActiveForm::end(); ?>
        	</div>
    	</div>
    </div>
</div>





