<?php
########################################################
#                                                      #
#               GOOD SOLUTIONS COLOMBIA                #
#            www.gsol.co - contacto@gsol.co            #
#                     GSOL Colombia                    #
#                   N.I.T 900065739-7                  #
########################################################

use yii\helpers\Html;
use yii\widgets\ListView;
use yii\widgets\Pjax;
//use app\assets\AppAsset;
use yii\helpers\Url;
use kartik\nav\NavX;
use backend\models\Mensajescategorias;

$this->title = Yii::$app->controller->action->id === 'index' ? 'Recibidos' : ucwords(Yii::$app->controller->action->id);

$this->params['breadcrumbs'][] = ['label' => 'Mensajes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Redactar', 'url' => 'create', 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

//Check

//$this->registerCssFile("@theme/backend/css/iCheck/custom.css");
//$this->registerJsFile("@theme/backend/js/iCheck/icheck.min.js");



$this->registerJs("
        $('.search-button').click(function(){
            $('.search-form').toggle(1000);
            return false;
        });

        $(document).ready(function(){
            $('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });
        });");


?>

        <div class="row">
            <div class="col-lg-2">
                <?= $this->render('_panel',['dataProvider' => $dataProvider]) ?>
            </div>
            
            <div class="col-lg-10">

            <div class="mail-box-header">
                <div class="categoria">
                    <?php 
                    
                        if(Yii::$app->request->get('categoria') != NULL)
                        {
                            $categoria = Mensajescategorias::findOne(Yii::$app->request->get('categoria'));

                            echo "<span class='label label-default pull-right' style='background:".$categoria->color.";'>"
                            .Html::encode($categoria->categoria)."</span>";
                        }    
                    ?> 

                </div>
                <h3>
                    <?= Yii::$app->controller->action->id === 'index' ? 'Recibidos' : ucwords(Yii::$app->controller->action->id); ?> 
                </h3>
                
                    <div class="search-form" style="display:<?= Yii::$app->request->get('MensajesSearch') ? 'block' : 'none' ?>;">
                        <?=  $this->render('_search_recibidos', ['model' => $searchModel]); ?>
                    </div>

            </div>
                <div class="mail-box">
                    <div class="mail-body">

                        <table class="table table-hover table-mail">
                            
                            <?php if($dataProvider->getTotalCount() > 0) { ?>     
                                <thead>
                                    <tr>
                                        <th><i class="far fa-flag"></i></th>
                                        <th>Categoría</th>                                
                                        <th>De</th>
                                        <th>Asunto</th>
                                        <th><i class="far fa-paperclip fa-lg"></i></th>
                                        <th>Fecha</th>
                                    </tr>
                                </thead>
                            <?php } ?>
                                 
                            <tbody>
                                <?= ListView::widget([
                                    'dataProvider' => $dataProvider,   
                                    //'layout' => "{summary}\n{items}\n{pager}",
                                    //'viewParams' => ['periodo' => $periodo],
                                    'itemView' => '_mensajes_recibidos',
                                    'itemOptions' => [
                                        'tag' => false,
                                    ],
                                ]) ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
 