<?php
########################################################
#                                                      #
#               GOOD SOLUTIONS COLOMBIA                #
#            www.gsol.co - contacto@gsol.co            #
#                     GSOL Colombia                    #
#                   N.I.T 900065739-7                  #
########################################################

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\FileInput;
use dosamigos\tinymce\TinyMce;


use backend\models\Tercero;
use backend\models\Tipotercero;
use backend\models\Grupo;
use backend\models\base\Mensajes;


$this->params['breadcrumbs'][] = ['label' => 'Mensajes', 'url' => ['index']];

if($model->remitente == Yii::$app->session->get('__tercero'))
{
    $this->title = 'Enviados';
    $this->params['breadcrumbs'][] = ['label' => 'Enviados', 'url' => ['enviados']];    
}
else
{
    $this->title = 'Recibidos';
    $this->params['breadcrumbs'][] = ['label' => 'Recibidos', 'url' => ['recibidos']]; 
}

$this->params['breadcrumbs'][] = $model->asunto;

$this->params['actions'][] = ['label' => 'Redactar', 'url' => 'create', 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];



$this->registerJs("
    $(document).ready(function(){
        $('.i-checks').iCheck({
            checkboxClass: 'icheckbox_square-green',
            radioClass: 'iradio_square-green',
        });
    });

    //$('.summernote').summernote();
");

?>

<div class="row">
    <div class="col-lg-2">
        <?= $this->render('_panel',['model' => $model]) ?>
    </div>
    
    <div class="col-lg-10"><!-- PANEL DERECHO -->
        
        <div class="mail-box-header">

            <div class="header-category" <?= $model->categoria == '' ? '' : 'style="background:'.$model->categorias->color.'"'?>>
                <i class="fa fa-envelope-o"></i>
                <?= $model->asunto ?>
            </div>
            
            <div class="row mail-tools tooltip-demo m-t-md">
                <div class='col-sm-2'>
                    <span class="font-noraml"><b>Categoría: </b></span>
                </div>
                <div class='col-sm-10'>
                    <?= $model->categoria == '' ?  'General' : $model->categorias->categoria ?>
                </div>

                <div class='col-sm-2'><span class='font-noraml'><b>Fecha: </b></span></div>
                <div class='col-sm-10'>
                    <? Yii::$app->formatter->locale = 'es-ES'; ?>
                    <?= Yii::$app->formatter->asDatetime($model->creado_el, 'full'); ?>
                </div>
            
                

                    <? 
                        if($model->remitente != Yii::$app->session->get('__tercero'))
                        {
                            echo "<div class='col-sm-2'><span class='font-noraml'><b>De: </b></span></div><div class='col-sm-10'>";
                            echo Html::encode(($model->remitente == NULL ) ? 'Administrador Sonic' : $model->remitentes->nombre);
                            echo "</div>";
                        }
                        else
                        {
                            echo "<div class='col-sm-2'><span class='font-noraml'><b>Para: </b></span></div><div class='col-sm-10'>";
                            
                            $estudiantes = Mensajes::find()->where(['mid' => $model->mid])->all();
                            
                            echo "<ul class='lista-bloque'>";

                            foreach ($estudiantes as $estudiante) {
     
                                echo "<li class='lista-bloque-item'><span class='lista-bloque-item-view'>";
                                echo ($estudiante->visto == '1') ? "<i class='far fa-eye text-primary' data-toggle='tooltip' data-original-title='".$estudiante->visto_el."'></i>" : "<i class='far fa-eye-slash text-danger'></i>";
                                echo "</span>".$estudiante->remisores->nombre."</li>";
                            }

                            echo "</ul>";

                            echo "<span class='pull-right'><i class='far fa-eye text-primary'></i> Visto &nbsp;&nbsp;&nbsp;<i class='far fa-eye-slash text-danger'></i> No Visto</span></div>";
                        }    
                        
                    ?>
                    
            </div>
        </div>
        <div class="mail-box">
            <div class="mail-body">
                <?= $model->mensaje ?>  
            </div>
            

            <? 
                //$adjuntos = [];

                if ($model->adjunto != '') 
                {
                    //$adjuntos = explode(',', $model->adjunto); 
                    
                    $adjuntos = json_decode(json_encode($model->adjunto),true);
                    
                    $adjuntos_cantidad = count($adjuntos);



            ?>

            <div class="mail-attachment"><!-- INICIO ATTACH -->
                <p>
                    <span><i class="far fa-paperclip"></i> <?=  ($adjuntos_cantidad > '1') ? $adjuntos_cantidad.' Archivos Adjuntos' : $adjuntos_cantidad.' Archivo Adjunto'?></span>
                </p>


                <div class="attachment">
                    
                    <? 
                        foreach ($adjuntos as $adjunto) { 
                            //$archivo = unserialize($adjunto);
                    ?>
                        

                        <div class="file-box">
                            <div class="file">
                                
                                <a href="<?= $adjunto["ObjectURL"] ?>" target="_blank">
                                    <span class="corner"></span>

                                    <?
                                        $cuenta = strlen('mensajes/'.$model->id.'/') + 51;
                                        $largo = strlen($adjunto["ObjectURL"]) - $cuenta;
                                        $archivo = substr($adjunto["ObjectURL"], $cuenta, $largo);
                                        $ext = substr($adjunto["ObjectURL"], -4);
                                        //$ext = substr($archivo["file"], -4);
                                        
                                        
                                            switch ($ext) {
                                                
                                                case '.jpg':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;

                                                case '.png':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break; 

                                                case '.gif':
                                                        $icon = 'far fa-file-image text-danger';
                                                    break;       

                                                case '.pdf':
                                                        $icon = 'far fa-file-pdf text-danger';
                                                    break;
                                                case '.xls':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case 'xlsx':
                                                        $icon = 'far fa-file-excel text-success';
                                                    break;
                                                case '.csv':
                                                        $icon = 'far fa-file-csv text-success';
                                                    break;       
                                                case 'docx':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case '.doc':
                                                        $icon = 'far fa-file-word text-primary';
                                                    break;
                                                case 'pptx':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                case '.ppt':
                                                        $icon = 'far fa-file-powerpoint text-danger';
                                                    break;
                                                        
                                                default:
                                                        $icon = 'far fa-file';
                                                    break;
                                            }
                                            echo "<div class='icon'><i class='".$icon."'></i></div>";

                                    ?>
                                    
                                    <div class="file-name">
                                        <?= urldecode($archivo); ?>
                                    </div>
                                </a>
                            </div>

                        </div>
                    <?php

                        }
                    ?>    
                    
                    <div class="clearfix"></div>
                </div> 

            </div><!-- FIN ATTACH -->

            <?php 
                
                }
                else
                { 
            ?>    
                        <div class="mail-attachment"><!-- INICIO ATTACH -->
                            <p>
                                <span><i class="far fa-paperclip"></i> Sin Archivos Adjuntos</span>
                            </p>
                        </div>
            <?php
                } 
             ?>  
            <div class="mail-body text-right tooltip-demo">
                <!--
                <a class="btn btn-sm btn-default" href="mail_compose.html"><i class="fa fa-reply"></i> Responder</a>
                
                <button title="" data-placement="top" data-toggle="tooltip" type="button" data-original-title="Print" class="btn btn-sm btn-white"><i class="fa fa-print"></i> Print</button>
                <button title="" data-placement="top" data-toggle="tooltip" data-original-title="Trash" class="btn btn-sm btn-white"><i class="fa fa-trash-o"></i> Remove</button>
            -->
            </div>
            <div class="clearfix"></div>
        </div>    
        
    </div><!-- FIN PANEL DERECHO -->
    
</div>

