<div class="form-group" id="add-mensajes">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Mensajes',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'visible' => false],
        'remitente' => [
            'label' => 'Tercero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Tercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tercero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'remisor' => [
            'label' => 'Tercero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Tercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tercero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'asunto' => ['type' => TabularForm::INPUT_TEXT],
        'importante' => ['type' => TabularForm::INPUT_TEXT],
        'mensaje' => ['type' => TabularForm::INPUT_TEXTAREA],
        'adjunto' => ['type' => TabularForm::INPUT_TEXTAREA],
        'visto' => ['type' => TabularForm::INPUT_TEXT],
        'visto_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Visto El',
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'creado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Creado El',
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'creado_por' => ['type' => TabularForm::INPUT_TEXT],
        'actualizado_el' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                'saveFormat' => 'php:Y-m-d H:i:s',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Actualizado El',
                        'autoclose' => true,
                    ]
                ],
            ]
        ],
        'actualizado_por' => ['type' => TabularForm::INPUT_TEXT],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowMensajes(' . $key . '); return false;', 'id' => 'mensajes-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Mensajes', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowMensajes()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

