<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Mensajescategorias */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Mensajescategorias', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="mensajescategorias-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Mensajescategorias'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'categoria',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
if($providerMensajes->totalCount){
    $gridColumnMensajes = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            [
                'attribute' => 'remitente0.id',
                'label' => 'Remitente'
            ],
            [
                'attribute' => 'remisor0.id',
                'label' => 'Remisor'
            ],
            'asunto',
                        'importante',
            'mensaje:ntext',
            'adjunto:ntext',
            'visto',
            'visto_el',
            'creado_el',
            'creado_por',
            'actualizado_el',
            'actualizado_por',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerMensajes,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-mensajes']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Mensajes'),
        ],
        'columns' => $gridColumnMensajes
    ]);
}
?>
    </div>
</div>