<?

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\TouchSpin;

use backend\models\Tipomenuweb;
use backend\models\Menuweb;


/*
\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Tercero', 
        'relID' => 'tercero', 
        'value' => \yii\helpers\Json::encode($model->terceros),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);*/
?>

<?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Item del Ménu</h3>
    </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'nombre')->textInput(['maxlength' => true, 'placeholder' => 'Nombre']) ?>
            </div>       
            <div class="col-sm-6">
                <?= $form->field($model, 'alias')->textInput(['maxlength' => true, 'placeholder' => 'Alias']) ?>
            </div> 
        </div>
        <div class="row">
            <div class="col-sm-6">    
                <?= $form->field($model, 'tipo')->widget(Select2::classname(), [
                    'data' => ArrayHelper::map(Tipomenuweb::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                    'options' => ['id'=>'tipo'],
                    'pluginOptions' => [
                        'placeholder' => Yii::t('app', 'Seleccione'),
                        'allowClear' => true,
                    ],
                ]) ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'item')->widget(DepDrop::classname(), [
                    //'data' => ArrayHelper::map(Municipio::find()->where(['=', 'departamento', $model->departamento])->orderBy('id')->asArray()->all(), 'id', 'nombre'),
                    'type'=>DepDrop::TYPE_SELECT2,
                    'options'=>['id'=>'item'],
                    'pluginOptions'=>[
                        'placeholder'=> Yii::t('app', 'Seleccione'),
                        'depends'=>['tipo'],
                        'url'=>Url::to(['finditem']),
                    ]
                ]);
                ?>  
            </div>
        </div>
        <div class="row">                    
            <div class="col-sm-6 clear">
                <?= $form->field($model, 'padre')->widget(Select2::classname(), [
                    'data' => \yii\helpers\ArrayHelper::map(Menuweb::find()->orderBy('id')->asArray()->all(), 'id', 'nombre'),
                    'options' => ['placeholder' => Yii::t('app', 'Seleccione')],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ]); ?>
            </div>       
            <div class="col-sm-6">
                <?= $form->field($model, 'orden')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Ordén'],]);?>
            </div>  
        </div>     
        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'medium',
                    'onColor' => 'success',
                    'offColor' => 'danger',
                    'onText'=>'Activo',
                    'offText'=>'Inactivo'
                ]]) 
                ?>
            </div> 
        </div>      
    </div>
    <?php ActiveForm::end(); ?>

</div>
