<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Menuweb */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Menuweb'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="menuweb-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Menuweb').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'tipos.id',
            'label' => Yii::t('app', 'Tipo'),
        ],
        'nombre',
        'alias',
        'controlador',
        'item',
        [
            'attribute' => 'padres.id',
            'label' => Yii::t('app', 'Padre'),
        ],
        'orden',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>

    
    <div class="row">
<?php
if($providerMenuweb->totalCount){
    $gridColumnMenuweb = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            [
                'attribute' => 'tipos.id',
                'label' => Yii::t('app', 'Tipo')
            ],
            'nombre',
            'alias',
            'controlador',
            'item',
            'orden',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerMenuweb,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-menu-web']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Menuweb')),
        ],
        'export' => false,
        'columns' => $gridColumnMenuweb
    ]);
}
?>

    </div>
    <div class="row">
        <h4>TipoMenuWeb<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnTipoMenuWeb = [
        ['attribute' => 'id', 'visible' => false],
    ];
    echo DetailView::widget([
        'model' => $model->tipos,
        'attributes' => $gridColumnTipoMenuWeb    ]);
    ?>
</div>
