<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\TouchSpin;
use kartik\widgets\SwitchInput;


use backend\models\Sede;
use backend\models\Tercero;
use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Competencia;


$this->title = 'Homologación';
$this->params['breadcrumbs'][] = ['label' => 'Homologar', 'url' => ['index']];

if(!isset($ver_parametros))
{
    $ver_parametros = false;
}


?>


<div class="row">

    <div class="col-sm-2 hidden-xs">
        <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed; z-index:0;']); ?>
    </div>    
    
    <div class="col-sm-10 col-xs-12">
    
        <div class="col-sm-12">
            <div class="form-group">
                <p class='titulo'><?= Yii::t('app', 'Message') ?></p>
                <p class='observaciones'><?= Html::encode($model->ids->message) ?> </p>
            </div>        
        </div>


        <?php $form = ActiveForm::begin(['id' => 'message-form', 'enableAjaxValidation' => true]); ?>
    
        <? $form->errorSummary($model); ?>
        
            <div class="col-sm-12 col-xs-12">
                <?= $form->field($model, 'translation')->textarea(['rows' => 1]) ?>
            </div>




        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align:right; padding-top: 10px;">
            <?= Html::submitButton('<i class="fa fa-pencil" aria-hidden="true"></i> '.Yii::t('app', 'Homologar'), ['class' => 'btn btn-warning']) ?>
            <?= Html::a('<i class="fa fa-times" aria-hidden="true"></i> '.Yii::t('app', 'Cancelar'), false , ['class'=> 'btn btn-danger', 'data-dismiss' => 'modal']) ?>        
        </div>

        <?php ActiveForm::end(); ?>

    </div>
</div>
