<?php

use yii\helpers\Html;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;
use yii\helpers\Url;


$this->title = Yii::t('app', 'Message');

$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Extraer', 'url' => 'extraer', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];


$search = "$('.search-button').click(function(){
    $('.search-form').toggle(1000);
    return false;
});";
$this->registerJs($search);
?>

<div class="academico-index">

        <div class="search-form" style="display:none">
            <?=  $this->render('_search', ['model' => $searchModel]); ?>
        </div>

    <?php 



                
                
                

    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'message',
            'format' => 'raw',
            'value' => function($model){
                return Html::a($model->ids->message,false,['value' => Url::to(['update', 'id' => $model->id]), 'title' => Yii::t('app', 'Translation'), 'class' => 'showModalButton', 'style' => 'cursor: pointer;']);
            },
            'label' => Yii::t('app', 'Message'),
            'filterInputOptions' => ['placeholder' => '', 'class' => 'form-control', 'id' => 'grid-message-search-message']
        ],
        [
            'attribute' => 'translation',
            'label' => Yii::t('app', 'Translation'),

        ],
        [
            'attribute' => 'languaje',
            'format' => 'raw',
            'value' => function($model){
                return Html::button('<i class="fa fa-pencil" aria-hidden="true"></i> <span class="hidden-xs">'.Yii::t('app', 'Translation').'</span>', ['value' => Url::to(['update', 'id' => $model->id]), 'title' => Yii::t('app', 'Translation'), 'class' => 'showModalButton btn btn-xs btn-warning']);
            },
            'label' => Yii::t('app', 'Actions'),
        ],
    ]; 
    ?>

<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>Yii::t('app', 'Crear')]) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>Yii::t('app', 'Volver a Cargar')])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'message'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>

</div>
