<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

Pjax::begin();
$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Grupo',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        'grado' => [
            'label' => 'Grado',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Grado::find()->orderBy('grado')->asArray()->all(), 'id', 'grado'),
                'options' => ['placeholder' => 'Seleccione Grado'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'grupo' => ['type' => TabularForm::INPUT_TEXT],
        'director' => [
            'label' => 'Tercero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Tercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Seleccione Tercero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'jornada' => [
            'label' => 'Jornada',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Jornada::find()->orderBy('jornada')->asArray()->all(), 'id', 'jornada'),
                'options' => ['placeholder' => 'Seleccione Jornada'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'sede' => [
            'label' => 'Sede',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Sede::find()->orderBy('sede')->asArray()->all(), 'id', 'sede'),
                'options' => ['placeholder' => 'Seleccione Sede'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'por_nota' => ['type' => TabularForm::INPUT_TEXT],
        'modalidad' => [
            'label' => 'Modalidad',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Modalidad::find()->orderBy('modalidad')->asArray()->all(), 'id', 'modalidad'),
                'options' => ['placeholder' => 'Seleccione Modalidad'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'especialidad' => [
            'label' => 'Especialidad',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Especialidad::find()->orderBy('especialidad')->asArray()->all(), 'id', 'especialidad'),
                'options' => ['placeholder' => 'Seleccione Especialidad'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Eliminar', 'onClick' => 'delRowGrupo(' . $key . '); return false;', 'id' => 'grupo-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . 'Grupo',
            'type' => GridView::TYPE_INFO,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . ' Agregar', ['type' => 'button', 'class' => 'btn btn-success kv-batch-Crear', 'onClick' => 'addRowGrupo()']),
        ]
    ]
]);
Pjax::end();
?>
