<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

$this->title = 'Ver Modalidad';
$this->params['breadcrumbs'][] = ['label' => 'Carga Académica', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Ver';

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'PDF', 'url' => 'pdf', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];

?>
<div class="modalidad-view">

    <div class="row">
<?php 
    $gridColumn = [
        'modalidad',
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
if($providerGrupo->totalCount){
    $gridColumnGrupo = [
        ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
            'grupo',
            [
                'attribute' => 'tercero.id',
                'label' => 'Director'
        ],
            [
                'attribute' => 'jornada.jornada',
                'label' => 'Jornada'
        ],
            [
                'attribute' => 'sede.sede',
                'label' => 'Sede'
        ],
            'por_nota',
            [
                'attribute' => 'metodologia.metodologia',
                'label' => 'Metodologia'
        ],
            [
                'attribute' => 'modalidad.modalidad',
                'label' => 'Modalidad'
        ],
            [
                'attribute' => 'especialidad.especialidad',
                'label' => 'Especialidad'
        ],
            [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo Gridview::widget([
        'dataProvider' => $providerGrupo,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-grupo']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Grupo'.' '. $this->title),
        ],
        'columns' => $gridColumnGrupo
    ]);
}
?>
    </div>
</div>