<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Momento */

$this->title = $model->momento;
$this->params['breadcrumbs'][] = ['label' => 'Momento', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="momento-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Momento'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'id',
        'momento',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
if($providerObservador->totalCount){
    $gridColumnObservador = [
        ['class' => 'yii\grid\SerialColumn'],
            'id',
            [
                'attribute' => 'estudiante0.id',
                'label' => 'Estudiante'
            ],
            'comprometidos',
                        [
                'attribute' => 'asignatura0.asignatura',
                'label' => 'Asignatura'
            ],
            [
                'attribute' => 'periodo0.periodo',
                'label' => 'Periodo'
            ],
            'fecha',
            [
                'attribute' => 'docente0.id',
                'label' => 'Docente'
            ],
            [
                'attribute' => 'claseObservacion.id',
                'label' => 'Clase Observacion'
            ],
            [
                'attribute' => 'tipoObservacion.id',
                'label' => 'Tipo Observacion'
            ],
            'descripcion:ntext',
            'descargos:ntext',
            'proceso:ntext',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerObservador,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-observador']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Observador'),
        ],
        'export' => false,
        'columns' => $gridColumnObservador
    ]);
}
?>
    </div>
</div>
