<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->barrios,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        'nombre',
        [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento'
        ],
        [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio'
        ],
        [
                'attribute' => 'comunas.nombre',
                'label' => 'Comuna'
        ],
        [
            'class' => 'yii\grid\ActionColumn',
            'contentOptions'=>['style'=>'width: 80px;'],
            'controller' => 'barrio'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
