<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Municipio */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Municipios', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="municipio-view">

    <div class="row">
        <div class="col-sm-12">
            <h2><?= 'Municipio'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'dane',
        'nombre',
        [
                'attribute' => 'departamento.id',
                'label' => 'Departamento'
        ],
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnBarrio = [
        ['class' => 'yii\grid\SerialColumn'],
        'nombre',
        [
                'attribute' => 'departamento.id',
                'label' => 'Departamento'
        ],
        [
                'attribute' => 'municipio.id',
                'label' => 'Municipio'
        ],
        [
                'attribute' => 'comuna.id',
                'label' => 'Comuna'
        ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerBarrio,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-barrio']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Barrio'.' '. $this->title),
        ],
        'columns' => $gridColumnBarrio
    ]);
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnComuna = [
        ['class' => 'yii\grid\SerialColumn'],
        'nombre',
        [
                'attribute' => 'departamento.id',
                'label' => 'Departamento'
        ],
        [
                'attribute' => 'municipio.id',
                'label' => 'Municipio'
        ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerComuna,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-comuna']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Comuna'.' '. $this->title),
        ],
        'columns' => $gridColumnComuna
    ]);
?>
    </div>
</div>
