<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Municipio */

$this->title = 'Ver Municipio: ' . ' ' . $model->nombre;
$this->params['breadcrumbs'][] = ['label' => 'Municipios', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->nombre, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = 'Ver';
?>
<div class="municipio-view">


    <div class="row">
<?php 
    $gridColumn = [
        'dane',
        'nombre',
        [
            'attribute' => 'departamentos.nombre',
            'label' => 'Departamento',
        ],
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
if($providerBarrio->totalCount){
    $gridColumnBarrio = [
        ['class' => 'yii\grid\SerialColumn'],
            'nombre',
            [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento'
        ],
            [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio'
        ],
            [
                'attribute' => 'comunas.nombre',
                'label' => 'Comuna'
        ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerBarrio,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-barrio']],
        'panel' => [
        'type' => GridView::TYPE_INFO,
        'heading' => '<span class="glyphicon glyphicon-info-sign"></span> ' . Html::encode('Barrios'.' de '. $model->nombre),
        ],
        'columns' => $gridColumnBarrio
    ]);
}
?>
    </div>
    
    <div class="row">
<?php
if($providerComuna->totalCount){
    $gridColumnComuna = [
        ['class' => 'yii\grid\SerialColumn'],
            'nombre',
            [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento'
        ],
            [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio'
        ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerComuna,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-comuna']],
        'panel' => [
        'type' => GridView::TYPE_INFO,
        'heading' => '<span class="glyphicon glyphicon-info-sign"></span> ' . Html::encode('Comunas'.' de '. $model->nombre),
        ],
        'columns' => $gridColumnComuna
    ]);
}
?>
    </div>
</div>