<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Nivel */

?>
<div class="nivel-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Html::encode($model->nivel) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'grados.grado',
            'label' => 'Grado',
        ],
        [
            'attribute' => 'asignaturas.asignatura',
            'label' => 'Asignatura',
        ],
        [
            'attribute' => 'periodos.periodo',
            'label' => 'Periodo',
        ],
        [
            'attribute' => 'competencias.competencia',
            'label' => 'Competencia',
        ],
        [
            'attribute' => 'desempenos.desempeno',
            'label' => 'Desempeno',
        ],
        'nivel:ntext',
        'recomendacion:ntext',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'eliminado_por',
        'eliminado_el',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
</div>