<?php


use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\widgets\TouchSpin;
use kartik\widgets\DepDrop;

use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Competencia;
use backend\models\Desempeno;

?>

<?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Nivel de Desempeño</h3>
    </div>

    <div class="panel-body" >

        <?= $form->errorSummary($model); ?>
        <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
        
        <div class="col-sm-9">            
            <?= $form->field($model, 'competencia')->widget(DepDrop::classname(), [
                    'type'=>DepDrop::TYPE_SELECT2,
                    'data' => ArrayHelper::map(Competencia::find()->orderBy('id')->asArray()->all(), 'id', 'competencia'),
                    'options'=>['id'=>'competencia-id'],
                    'pluginOptions'=>[
                        'placeholder'=>'Seleccione la Competencia',
                        'depends'=>['asignatura-id', 'periodo-id'],
                        'url'=>Url::to(['publica/findcompetencias']),
                    ]
                ]);
            ?>
        </div>
        <div class="col-sm-3">
            <? 
                if(!$model->isNewRecord)
                {
                    $desempeno = ArrayHelper::map(Desempeno::find()->where(['tipo_calificacion' => '1'])->orderBy('id')->asArray()->all(), 'id', 'desempeno');
                }
                else{
                    $desempeno = NULL;
                }
            ?>    
            <? $form->field($model, 'desempeno')->widget(DepDrop::classname(), [
                    'type'=>DepDrop::TYPE_SELECT2,
                    'data' => $desempeno,
                    'options'=>['id'=>'desempeno-id'],
                    'pluginOptions'=>[
                        'placeholder'=>'Seleccione el Desempeño',
                        'depends'=>['competencia-id'],
                        'url'=>Url::to(['publica/finddesempenos']),
                    ]
                ]);
            ?>

            <?= $form->field($model, 'desempeno')->widget(\kartik\widgets\Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\base\Desempeno::find()->where(['tipo_calificacion' => '1'])->orderBy('id')->asArray()->all(), 'id', 'desempeno'),
                'options' => ['placeholder' => 'Seleccione Desempeño'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
                //'pluginLoading' =>true,
            ]) ?>

        </div>

        <div class="clear"></div>
        
        <div class="col-sm-12">
            <?= $form->field($model, 'nivel')->textarea(['rows' => 3]) ?>
        </div>

        <div class="clear"></div>
        
        <div class="col-sm-12">
            <?= $form->field($model, 'recomendacion')->textarea(['rows' => 3]) ?>
        </div>
    </div>
</div>

    <?php ActiveForm::end(); ?>
