<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Nivel */

$this->title = $model->nivel;
$this->params['breadcrumbs'][] = ['label' => 'Nivel', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="nivel-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Nivel'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
                'attribute' => 'grado0.grado',
                'label' => 'Grado'
            ],
        [
                'attribute' => 'asignatura0.asignatura',
                'label' => 'Asignatura'
            ],
        [
                'attribute' => 'periodo0.periodo',
                'label' => 'Periodo'
            ],
        [
                'attribute' => 'competencia0.competencia',
                'label' => 'Competencia'
            ],
        [
                'attribute' => 'desempeno0.desempeno',
                'label' => 'Desempeno'
            ],
        'nivel:ntext',
        'recomendacion:ntext',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'eliminado_por',
        'eliminado_el',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
</div>
