<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\NivelSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;


use backend\models\Competencia;
use backend\models\Carga;
use backend\models\Grado;
use backend\models\Periodo;

$this->title = 'Niveles';
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];


$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="nivel-index">
    
    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 

    //echo "Periodo: ".Yii::$app->request->get('NivelSearch[periodo]');

    //echo Yii::$app->request->queryParams ? Yii::$app->request->queryParams['NivelSearch']['periodo'] : 'No parametros';

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $asignaturas = Carga::find()->select(['asignatura.id as id', 'concat(asignatura.asignatura, " - " , grado.grado) as asignatura'])->joinWith(['asignaturas', 'asignaturas.grados'])->where(['docente' => Yii::$app->session->get('__tercero')])->asArray()->all();

            $carga = Carga::find()->select(['asignatura'])->where(['docente' =>  Yii::$app->session->get('__tercero')])->andWhere(['eliminado_por' => '0']);
            
            if(isset(Yii::$app->request->queryParams['NivelSearch']['periodo']))
            {
                //echo "Si";
            }
            else
            {
                //echo "No";
            }
            $competencias = Competencia::find()->where(['IN', 'asignatura', $carga])->andWhere(['eliminado_por' => '0'])->all();
        }
        else
        {
            $asignaturas = Carga::find()->select(['asignatura.id as id', 'asignatura.asignatura as asignatura'])->joinWith(['asignaturas'])->asArray()->all();   
            $competencias = Competencia::find()->asArray()->all();
        }


    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        [
            'class' => 'kartik\grid\ExpandRowColumn',
            'width' => '50px',
            'value' => function ($model, $key, $index, $column) {
                return GridView::ROW_COLLAPSED;
            },
            'detail' => function ($model, $key, $index, $column) {
                return Yii::$app->controller->renderPartial('_expand', ['model' => $model]);
            },
            'headerOptions' => ['class' => 'kartik-sheet-style'],
            'expandOneOnly' => true
        ],
        ['attribute' => 'id', 'visible' => false],
        [
                'attribute' => 'grado',
                'label' => 'Grado',
                'value' => function($model){                   
                    return $model->grados->grado;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(Grado::getGradobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-nivel-search-grado']
            ],
        [
                'attribute' => 'asignatura',
                'label' => 'Asignatura',
                'value' => function($model){                   
                    return $model->asignaturas->asignatura;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map($asignaturas, 'id', 'asignatura'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Asignatura', 'id' => 'grid-nivel-search-asignatura'],
            ],
        [
                'attribute' => 'periodo',
                'label' => 'Periodo',
                'value' => function($model){                   
                    return $model->periodos->periodo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(Periodo::find()->asArray()->all(), 'id', 'periodo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Periodo', 'id' => 'grid-nivel-search-periodo']
            ],
        [
                'attribute' => 'competencia',
                'label' => 'Competencia',
                'value' => function($model){                   
                    return $model->competencias->competencia;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map($competencias, 'id', 'competencia'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Competencia', 'id' => 'grid-nivel-search-competencia'],
            ],
        [
            'attribute' => 'desempeno',
            'format' => 'RAW',
            'value' => function($model){
                return '<span class="label" style="width:50px; background-color:'.$model->desempenos->color.'; color:#fff">'.$model->desempenos->desempeno.'</span>';
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Desempeno::find()->asArray()->all(), 'id', 'desempeno'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Desempeño', 'id' => 'grid-nivel-search-desempeno']    
        ],
        [
                'attribute' => 'nivel',
                'visible' => true,
        ],             
        [
                'attribute' => 'recomendacion',
                'visible' => true,
        ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class' => 'yii\grid\ActionColumn',
        ],
    ]; 
    ?>

<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'nivel'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>


</div>
