<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;

use kartik\widgets\DepDrop;

use backend\models\Grado;
use backend\models\Asignatura;
use backend\models\Periodo;


$this->registerJs("

$(document).ready(function() {
    
    $('#aplicar').click(function() {
        
        $('#aplicar').prop('disabled', true);
        id = $('#nivel-id').val();
        competencia = $('#nivel-competencia').val();
        desempeno = $('#nivel-desempeno').val();
        tipo_desempeno = $('#nivel-desempeno option:selected').text();
        nivel = $('#nivel-nivel').val();
        recomendacion = $('#nivel-recomendacion').val();
        
            
        if(!desempeno)
        {
            $('.field-nivel-desempeno > .help-block-error').html('<span style=\"color: #a94442\">Desempeño no puede estar vacío.</span>');   
        }

        if(!nivel)
        {
            $('.field-nivel-nivel > .help-block-error').html('<span style=\"color: #a94442\">Nivel no puede estar vacío.</span>');   
        }

        $.ajax({
            type: 'POST',
            url: '". Url::to(['save'])."',
            timeout: 1000,

            data: {id : id, competencia : competencia, desempeno : desempeno, nivel: nivel, recomendacion: recomendacion},

            success: function (data) {
                
                if(data != '')
                {
                    //$('#list-tab').append('<a class=\"list-group-item list-group-item-action\" id=\"' + data + '\" data-toggle=\"list\" href=\"#list-' + data + '\" role=\"tab\" aria-controls=\"list-' + data + '\">' + nivel + '<button type=\"button\" id=\"addbutton\" class=\"showModalButton btn btn-xs btn-warning\" value=\"/sonic/admin/frd/add?competencia=' + competencia + '&amp;nivel=' + data + '\" title=\"Agregar FRD\" style=\"float:right;\"><i id=\"showCreateFRD\" class=\"fa fa-plus\" aria-hidden=\"true\"></i> Agregar FRD</button></a>');
                    
                    $('#list-tab').append('<a class=\"list-group-item list-group-item-action\" id=\"nivel-' + data + '\" data-toggle=\"list\" href=\"#list-' + data + '\" role=\"tab\" aria-controls=\"list-' + data + '\" aria-selected=\"false\">' + nivel + '<div class=\"btn-group\" style=\"float:right; padding-left: 10px;\"><button type=\"button\" class=\"btn btn-xs btn-danger btn-xs\" value=\"../nivel/delete?id=' + data + '\" title=\"\" data-toggle=\"tooltip\" style=\"float:right;\" onclick=\"eliminar_nivel(' + data + ')\" data-original-title=\"Eliminar\"><i id=\"trash\" class=\"fa fa-trash-alt\" aria-hidden=\"true\"></i></button><button type=\"button\" class=\"showModalButton btn btn-xs btn-success btn-xs\" value=\"../nivel/update?id=' + data + '\" title=\"\" data-toggle=\"tooltip\" style=\"float:right;\" data-original-title=\"Editar\"><i id=\"edit\" class=\"fa fa-pencil\" aria-hidden=\"true\"></i></button><button type=\"button\" id=\"addbutton\" class=\"showModalButton btn btn-xs btn-primary\" value=\"../frd/add?competencia=' + competencia + '&amp;nivel=' + data + '\" title=\"Agregar FRD\"><i id=\"showCreateFRD\" class=\"fa fa-plus\" aria-hidden=\"true\"></i> FRD</button></div><span class=\"badge badge-pill\" style=\"color:#fff; background-color:#ccc' + data + ';\">'+ tipo_desempeno +'</span></a>');
                    
                    $('#nav-tabContent-frd').append('<div class=\"tab-pane fade in show\" id=\"list-' + data + '\" role=\"tabpanel\" aria-labelledby=\"list-' + data + '-list\"><ul id=\"list-frd\" class=\"list-group\"><li id=\"no-item\" class=\"list-group-item d-flex justify-content-between align-items-center\">No hay registros de fortalezas, recomendaciones y debilidades almacenados.</li></ul></div>');


                    $('#modal').modal('hide'); //ocultamos el modal
                    $('body').removeClass('modal-open');    //eliminamos la clase del body para poder hacer scroll
                    $('.modal-backdrop').remove();  //eliminamos el backdrop del modal
                        

                    swal({
                        title: 'Enhorabuena!',
                        text: 'Se agrego satisfactoriamente.',
                        type: 'success',
                        allowOutsideClick: false,
                        timer: 1000,
                    });
                    
                    location.reload(false);
                }
                
            },
            error: function(request, status, err) {
                if (status == 'timeout') {
                    //timeout -> reload the page and try again
                    $('#info').html(\"<i class='fas fa-times text-danger'></i>\");
                    console.log('timeout');
                    //window.location.reload();
                } else {
                    $('#info').html(\"<span class='text-danger'>\"+ err + \"</span>\");
                    //another error occured  
                    //alert('error: ' + request + status + err);
                }
            }
    
        });
        
    });

});

");

?>

 <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'enableAjaxValidation' => true,
        //'action' => Url::toRoute('user/ajaxregistration'),
        'validationUrl' => Url::toRoute('save'),

        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                      'enctype'=>'multipart/form-data',
                    ]
    ]); ?>


    <div class="row">

        <div class="col-sm-2 hidden-xs">
            <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed; z-index:0;']); ?>
        </div>

        <div class="col-sm-10 col-xs-12">.

            <?= $form->errorSummary($model); ?>
            
            <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

            <?= $form->field($model, 'competencia', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
            
            <?= $form->field($model, 'desempeno')->widget(\kartik\widgets\Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Desempeno::find()->where(['tipo_calificacion' => $model->competencias->grados->tipo_calificacion])->orderBy('id')->asArray()->all(), 'id', 'desempeno'),
                'options' => ['placeholder' => Yii::t('app', 'Seleccione')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]); ?>

            <?= $form->field($model, 'nivel')->textarea(['rows' => 3]) ?>

            <?= $form->field($model, 'recomendacion')->textarea(['rows' => 3]) ?>
        </div>

        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align:right; padding-top: 10px;">
            <?= Html::Button($model->isNewRecord ? '<i class="glyphicon glyphicon-plus"></i>' . ' Agregar' : '<i class="glyphicon glyphicon-pencil"></i>' . ' Actualizar', ['type' => 'button', 'class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-success', 'id' => 'aplicar']) ?>
            <?= Html::a('<i class="fa fa-times" aria-hidden="true"></i><span> Cancelar', false , ['class'=> 'btn btn-danger', 'data-dismiss' => 'modal']) ?>        
        </div>
        
    </div>
        
<?php ActiveForm::end(); ?>
