<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Nivel */

$this->title = $model->nivel;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Nivel'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="nivel-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Nivel').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'competencia0.competencia',
            'label' => Yii::t('app', 'Competencia'),
        ],
        [
            'attribute' => 'desempeno0.desempeno',
            'label' => Yii::t('app', 'Desempeno'),
        ],
        'nivel:ntext',
        'recomendacion:ntext',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerFrd->totalCount){
    $gridColumnFrd = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            [
                'attribute' => 'competencia0.competencia',
                'label' => Yii::t('app', 'Competencia')
            ],
                        [
                'attribute' => 'frdTipo.id',
                'label' => Yii::t('app', 'Frd Tipo')
            ],
            'descripcion:ntext',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerFrd,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-frd']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Frd')),
        ],
        'export' => false,
        'columns' => $gridColumnFrd
    ]);
}
?>

    </div>
    <div class="row">
        <h4>Competencia<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnCompetencia = [
        ['attribute' => 'id', 'visible' => false],
        'grado',
        'asignatura',
        'periodo',
        'estandar',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->competencia0,
        'attributes' => $gridColumnCompetencia    ]);
    ?>
    <div class="row">
        <h4>Desempeno<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnDesempeno = [
        ['attribute' => 'id', 'visible' => false],
        'tipo_calificacion',
        'limite_inferior',
        'limite_superior',
        'color',
        'nota',
        'emoticons',
        'perdido',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->desempeno0,
        'attributes' => $gridColumnDesempeno    ]);
    ?>
</div>
