
$('i.glyphicon-refresh-animate').hide();

function updateRoutes(r) {
    _opts.estudiantes.avaliable = r.estudiantes.avaliable;
    _opts.estudiantes.assigned = r.estudiantes.assigned;
    search('avaliable');
    search('assigned');
}

$('#btn-new').click(function () {
    var $this = $(this);
    var route = $('#inp-route').val().trim();
    if (route != '') {
        $this.children('i.glyphicon-refresh-animate').show();
        $.post($this.attr('href'), {route: route}, function (r) {
            $('#inp-route').val('').focus();
            updateRoutes(r);
        }).always(function () {
            $this.children('i.glyphicon-refresh-animate').hide();
        });
    }
    return false;
});

$('.btn-assign').click(function () {
    var $this = $(this);
    var target = $this.data('target');
    var routes = $('select.list[data-target="' + target + '"]').val();

    if (routes && routes.length) {
        $this.children('i.glyphicon-refresh-animate').show();
        $.post($this.attr('href'), {routes: routes}, function (r) {
            updateRoutes(r);
        }).always(function () {
            //$this.children('i.glyphicon-refresh-animate').hide();
            //$icon.removeClass('glyphicon-refresh-animate').delay(2000);
        });
        $this.children('i.glyphicon-refresh-animate').hide();
    }
    
    return false;
});

$('#btn-refresh').click(function () {
    var $icon = $(this).children('span.glyphicon');
    $icon.addClass('glyphicon-refresh-animate');
    $.post($(this).attr('href'), function (r) {
        updateRoutes(r);
    }).always(function () {
        $icon.removeClass('glyphicon-refresh-animate');
    });
    return false;
});

$('.search[data-target]').keyup(function () {
    search($(this).data('target'));
});


function search(target) {

    var $list = $('select.list[data-target="' + target + '"]');
    $list.html('');
    
    var q = $('.search[data-target="' + target + '"]').val();

    //alert('Buscar: ' + q +'-'+target);

    $.each(_opts.estudiantes[target], function () {
        var r = this;
        
        if((r.nombre !== null) || (r.grupo !== null))
        {
            if ((r.nombre.toLowerCase().indexOf(q) >= 0) || (r.grupo.toLowerCase().indexOf(q) >= 0))
            {
             
                $('<option>').html(r.nombre + '&nbsp&nbsp.. <span class="badge badge-info">' + r.grupo + '</span>').val(r.id).appendTo($list);                
            }
        }
    });
}

// initial
search('avaliable');
search('assigned');
