<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
//use yii\helpers\ArrayHelper;
//use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DateTimePicker;
use kartik\widgets\Select2;
//use kartik\widgets\DepDrop;
use yii\helpers\Json;
use mdm\admin\AnimateAsset;
use yii\web\YiiAsset;

//use backend\models\Tercero;
//use backend\models\Grado;
//use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Momento;
use backend\models\Claseobservacionobservador;
use backend\models\Tipoobservacionobservador;
//use dosamigos\tinymce\TinyMce;



$this->registerCss("
.glyphicon-refresh-animate {
    -animation: spin .7s infinite linear;
    -ms-animation: spin .7s infinite linear;
    -webkit-animation: spinw .7s infinite linear;
    -moz-animation: spinm .7s infinite linear;
}

@keyframes spin {
    from { transform: scale(1) rotate(0deg);}
    to { transform: scale(1) rotate(360deg);}
}
  
@-webkit-keyframes spinw {
    from { -webkit-transform: rotate(0deg);}
    to { -webkit-transform: rotate(360deg);}
}

@-moz-keyframes spinm {
    from { -moz-transform: rotate(0deg);}
    to { -moz-transform: rotate(360deg);}
}
");

AnimateAsset::register($this);
YiiAsset::register($this);


$opts = Json::htmlEncode([
    'estudiantes' => $estudiantes
]);


$this->registerJs("var _opts = {$opts};");

$this->registerJs($this->render('_form.js'));

$animateIcon = ' <i class="glyphicon glyphicon-refresh glyphicon-refresh-animate"></i>';

$this->registerJs("
    
    $('#add').click(function() { return !$('#avaliable option:selected').remove().appendTo('#assigned'); });  
    $('#remove').click(function() { return !$('#assigned option:selected').remove().appendTo('#avaliable'); });
    
   // $('.submit').click(function() { $('#assigned option').prop('selected', 'selected'); });

");



$this->registerCss("
    #avaliable
    {
        height: 250px;   
    }
    #assigned
    {
        height: 280px;   
    }
");


//print_r($estudiantes);
//var_dump($estudiantes)
?>

<script>
function Asignatura() 
    {
        opcion = document.getElementById('observador-momento').value;

        if(opcion == '1')
        {
            document.getElementById('observador-asignatura').disabled = false; 
        }
        else
        {
            document.getElementById('observador-asignatura').disabled = true;
            document.getElementById('observador-asignatura').selectedIndex = 0;
        }
    }
</script>


     <?php $form = ActiveForm::begin([
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                    ]
    ]); ?>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Observador del Estudiante</h3>
    </div>

    <div class="panel-body" >

        <div class="row">
            <div class="col-sm-12">
                <?= $form->errorSummary($model); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-info">
                  <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                  <i class="fa fa-info-circle fa-lg"></i> <strong>Información!</strong> Seleccione uno o más estudiantes involucrados en la observación del estudiante, para seleccionarlo puede buscarlo por la casilla <em>Buscar estudiante</em> selecciona uno o más y haces click al botón azul. Así mismo puedes eliminarlos con el botón rojo. Cuando hay más de un estudiante involucrado se generará una observación independiente por cada estudiante.
                </div>
            </div>
        </div>
  

        
        <div class="row">
            <div class="col-sm-5">
                <label>Estudiantes</label>
                <div class="input-group">
                    <input class="form-control search" data-target="avaliable" placeholder="Buscar estudiante">
                    <span class="input-group-btn">
                        <?= Html::a('<span class="glyphicon glyphicon-refresh"></span>', ['refresh'], [
                            'class' => 'btn btn-default',
                            'id' => 'btn-refresh'
                        ]) ?>
                    </span>
                </div>
               
               <select multiple size="13" class="form-control list" id="avaliable" data-target="avaliable"></select>
            </div>
            <div class="col-sm-2" style="text-align: center;">
                <br><br>
                    <?= Html::a('<i class="fa fa-chevron-right"></i><i class="fa fa-chevron-right"></i>' . $animateIcon, ['assign'], [
                        'class' => 'btn btn-success btn-assign',
                        'data-target' => 'avaliable',
                        'data-toggle' => 'tooltip',
                        'id' => 'add',
                        'title' => 'Agregar'
                    ]) ?><br><br>
                    <?= Html::a('<i class="fa fa-chevron-left"></i><i class="fa fa-chevron-left"></i>' . $animateIcon, ['remove'], [
                        'class' => 'btn btn-danger btn-assign',
                        'data-target' => 'assigned',
                        'data-toggle' => 'tooltip',
                        'id' => 'remove',
                        'title' => 'Eliminar'
                    ]) ?>
                <br><br>
            </div>
            <div class="col-sm-5">
                <label>Comprometidos</label>
                <div class="input-group">
                    <input class="form-control search" data-target="assigned" placeholder="Buscar estudiante">
                    <span class="input-group-btn">
                        <?= Html::a('<span class="glyphicon glyphicon-refresh"></span>', ['refresh'], [
                            'class' => 'btn btn-default',
                            'id' => 'btn-refresh2'
                        ]) ?>
                    </span>
                </div>
                <!--<select multiple size="13" class="form-control list" id="assigned" data-target="assigned"></select>-->

                <?= 
                    $form->field($model, 'comprometidos[]')            
                     ->dropDownList([],[
                      'multiple'=>'multiple',
                      'class'=>'form-control list',
                      'data-target' => 'assigned',
                      'id' => 'assigned',
                      'size' => '13',
                     ]             
                    )->label(false);  
                ?>

            </div>
        </div>
 
    <?
        if($model->isNewRecord && Yii::$app->request->get('asignatura') !='')
        {
            $model->momento = '1';    
            $model->asignatura = Yii::$app->request->get('asignatura');
        }    
    ?>
        <div class="row">    
            <div class="col-sm-3">
                <?= $form->field($model, 'momento')->widget(Select2::class, [
                    'data' => \yii\helpers\ArrayHelper::map(Momento::find()->orderBy('id')->asArray()->all(), 'id', 'momento'),
                    'options' => ['placeholder' => 'Seleccione el Momento'],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                    'pluginEvents' => [
                       'select2:select' => 'function() { Asignatura(); }',
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">
                
                <?= $form->field($model, 'asignatura')->widget(Select2::class, [
                    'data' => \yii\helpers\ArrayHelper::map(Asignatura::find()->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
                    'options' => ['placeholder' => 'Seleccione la Asignatura'],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">
                <? 
                    if($model->isNewRecord)
                    {
                        $periodo = new Periodo();
                        $model->periodo = $periodo->actual->id;
                    }    
                ?>    
                <?= $form->field($model, 'periodo')->widget(Select2::class, [
                    'data' => \yii\helpers\ArrayHelper::map(Periodo::find()->where(['estado' => 1])->orderBy('id')->asArray()->all(), 'id', 'periodo'),
                    'options' => ['placeholder' => 'Seleccione el Periodo'],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">

                <?= $form->field($model, 'fecha')->widget(DateTimePicker::class, [
                    'options' => ['placeholder' => 'Enter event time ...'],
                    'pluginOptions' => [
                        'autoclose' => true
                    ]   
                ]);

                ?>
            </div>
        </div>
    
        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'clase_observacion')->widget(Select2::class, [
                    'data' => \yii\helpers\ArrayHelper::map(Claseobservacionobservador::find()->orderBy('id')->asArray()->all(), 'id', 'clase'),
                    'options' => ['placeholder' => 'Seleccione la Clase de Observación'],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ]); ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'tipo_observacion')->widget(Select2::class, [
                    'data' => \yii\helpers\ArrayHelper::map(Tipoobservacionobservador::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                    'options' => ['placeholder' => 'Seleccione el Tipo de Observación'],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                
                <?= $form->field($model, 'descripcion')->textarea(['rows' => '8']) ?>
                
                <? $form->field($model, 'descripcion')->widget(TinyMce::class, [
                    'options' => ['rows' => 8],
                    'language' => 'es',
                    'clientOptions' => [
                        'plugins' => [
                            "advlist lists link charmap print preview anchor",
                            "searchreplace fullscreen",
                            "table paste"
                        ],
                        'menu' => [
                            'edit' => ['title' => 'Editar', 'items' => 'undo redo | cut copy paste pastetext | selectall | searchreplace'],
                            'view' => ['title' => 'Ver', 'items' => 'preview fullscreen'],
                            'format' => ['title' => 'Formato', 'items' => 'bold italic underline strikethrough superscript subscript | formats | removeformat'],
                            'table' => ['title' => 'Tabla', 'items' => 'inserttable tableprops deletetable | cell row column'],
                        ],

                        'toolbar' => "print | undo redo | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist"
                    ]
                ]);?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12"> 
                
                <?= $form->field($model, 'descargos')->textarea(['rows' => '8']) ?>

                <? $form->field($model, 'descargos')->widget(TinyMce::class, [
                    'options' => ['rows' => 8],
                    'language' => 'es',
                    'clientOptions' => [
                        'plugins' => [
                            "advlist lists link charmap print preview anchor",
                            "searchreplace fullscreen",
                            "table paste"
                        ],
                        'menu' => [
                            'edit' => ['title' => 'Editar', 'items' => 'undo redo | cut copy paste pastetext | selectall | searchreplace'],
                            'view' => ['title' => 'Ver', 'items' => 'preview fullscreen'],
                            'format' => ['title' => 'Formato', 'items' => 'bold italic underline strikethrough superscript subscript | formats | removeformat'],
                            'table' => ['title' => 'Tabla', 'items' => 'inserttable tableprops deletetable | cell row column'],
                        ],

                        'toolbar' => "print | undo redo | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist"
                    ]
                ]);?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <?= $form->field($model, 'proceso')->textarea(['rows' => '8']) ?>

                <? $form->field($model, 'proceso')->widget(TinyMce::class, [
                    'options' => ['rows' => 8],
                    'language' => 'es',
                    'clientOptions' => [
                        'plugins' => [
                            "advlist lists link charmap print preview anchor",
                            "searchreplace fullscreen",
                            "table paste"
                        ],
                        'menu' => [
                            'edit' => ['title' => 'Editar', 'items' => 'undo redo | cut copy paste pastetext | selectall | searchreplace'],
                            'view' => ['title' => 'Ver', 'items' => 'preview fullscreen'],
                            'format' => ['title' => 'Formato', 'items' => 'bold italic underline strikethrough superscript subscript | formats | removeformat'],
                            'table' => ['title' => 'Tabla', 'items' => 'inserttable tableprops deletetable | cell row column'],
                        ],

                        'toolbar' => "print | undo redo | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist"
                    ]
                ]);?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

                <? 
                    if(!$model->isNewRecord)
                    {
                        echo $form->field($model, 'estado')->widget(SwitchInput::class, ['pluginOptions' => [
                            'size' => 'medium',
                            'onColor' => 'success',
                            'offColor' => 'danger',
                            'onText'=>'Activo',
                            'offText'=>'Inactivo'
                        ]]);
                    }     
                ?>
            </div>
        </div>
<!--
    <div class="col-sm-12">

        <div class="form-group">
        <?php if(Yii::$app->controller->action->id != 'save-as-new'): ?>
            <?= Html::submitButton($model->isNewRecord ? 'Crear' : 'Actualizar', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        <?php endif; ?>
        <?php if(Yii::$app->controller->action->id != 'create'): ?>
            <?= Html::submitButton('Guardar como nuevo', ['class' => 'btn btn-info', 'value' => '1', 'name' => '_asnew']) ?>
        <?php endif; ?>
        </div>
    </div>
-->
    <?php ActiveForm::end(); ?>
    </div>
</div>
