<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Observador */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Observadors', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="observador-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Observador'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
                'attribute' => 'estudiante0.id',
                'label' => 'Estudiante'
            ],
        'comprometidos',
        'momento',
        [
                'attribute' => 'asignatura0.asignatura',
                'label' => 'Asignatura'
            ],
        [
                'attribute' => 'periodo0.periodo',
                'label' => 'Periodo'
            ],
        'fecha',
        [
                'attribute' => 'docente0.id',
                'label' => 'Docente'
            ],
        [
                'attribute' => 'claseObservacion.id',
                'label' => 'Clase Observacion'
            ],
        [
                'attribute' => 'tipoObservacion.id',
                'label' => 'Tipo Observacion'
            ],
        'descripcion:ntext',
        'descargos:ntext',
        'proceso:ntext',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
</div>
