<?php

use yii\helpers\Html;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;
use backend\models\Tercero;
use kartik\dialog\Dialog;

yii\bootstrap\Modal::begin([
    'id' => 'modal',
    'header' => 'Estudiantes Comprometidos',
]);
yii\bootstrap\Modal::end();


$this->title = 'Observador del Estudiante';
$this->params['breadcrumbs'][] = $this->title;


$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
    

$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});

$(function() {
   $('.popupModal').click(function(e) {
     e.preventDefault();
     $('#modal').modal('show').find('.modal-body')
     .load($(this).attr('href'));
   });
});

";
$this->registerJs($search);

?>
<div class="observador-index">

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class'=>'kartik\grid\SerialColumn', 'order'=>DynaGrid::ORDER_FIX_LEFT],
        [
            'class' => 'kartik\grid\ExpandRowColumn',
            'width' => '50px',
            'value' => function ($model, $key, $index, $column) {
                return GridView::ROW_COLLAPSED;
            },
            'detail' => function ($model, $key, $index, $column) {
                return Yii::$app->controller->renderPartial('_expand', ['model' => $model]);
            },
            'headerOptions' => ['class' => 'kartik-sheet-style'],
            'expandOneOnly' => true
        ],
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => '', 
            'format' => 'raw',
            'width' => '50px',
            'value' => function($model){
                return Html::img($model->estudiantes->foto ? '@web/uploads/thumbnail/sm-'.$model->estudiantes->foto : '@web/images/user.jpg', ['class'=>'img-36 rounded-circle']);
            },
            'filter'=>false,
            'visible' => true
        ],
        [
                'attribute' => 'estudiante',
                'label' => 'Estudiante',
                'value' => function($model){
                    return $model->estudiantes->nombre;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['<', 'estado', '3'])->andWhere(['tipo_tercero' => '1'])->asArray()->all(), 'id', 'nombre'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-observador-search-estudiante']
            ],
        [
                'attribute' => 'comprometidos',
                'label' => 'Comprometidos',
                'width' => '220px',
                'visible' => true,
                'format' => 'raw',
                'value' => function($model){

                    return  Html::a('Detalles', ['observador/comprometidos','id'=>$model->comprometidos], ['class' => 'popupModal btn btn-success', 'id' => $model->id]);  
                    /*
                    $array = explode(",", $model->comprometidos);
                    $estudiantes = '';
                    foreach ($array as $id) {
                        $estudiantes .= Tercero::find()->where(['id' => $id])->one()->nombre.'<br>';
                    }

                    return $estudiantes; */
                },
            ],
        [
                'attribute' => 'momento',
                'visible' => false,
        ],
        [
                'attribute' => 'asignatura',
                'label' => 'Asignatura',
                'visible' => false,
                'value' => function($model){
                    return $model->asignaturas->asignatura;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Asignatura::find()->asArray()->all(), 'id', 'asignatura'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Asignatura', 'id' => 'grid-observador-search-asignatura']
            ],
        [
                'attribute' => 'periodo',
                'label' => 'Periodo',
                'visible' => false,
                'value' => function($model){
                    return $model->periodos->periodo;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->asArray()->all(), 'id', 'periodo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Periodo', 'id' => 'grid-observador-search-periodo']
            ],
        [
            'attribute' => 'fecha',
            'label' => 'Fecha y Hora',
            'filterType' => GridView::FILTER_DATE,
            'filterWidgetOptions' => [
                'language' => 'es',
                'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true],
            ],
            'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-observador-search-fecha']
           
        ],
        [
                'attribute' => 'docente',
                'label' => 'Docente',
                'value' => function($model){
                    return $model->docentes->nombre;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '5', 'tipo_tercero' => '2'])->asArray()->all(), 'id', 'nombre'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-observador-search-docente']
            ],
        [
                'attribute' => 'clase_observacion',
                'label' => 'Clase Observacion',
                'visible' => false,
                'value' => function($model){
                    return $model->claseObservacion->clase;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Claseobservacionobservador::find()->asArray()->all(), 'id', 'clase'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Clase ', 'id' => 'grid-observador-search-clase_observacion']
            ],
        [
                'attribute' => 'tipo_observacion',
                'label' => 'Tipo Observacion',
                'visible' => false,
                'value' => function($model){
                    return $model->tipoObservacion->tipo;
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tipoobservacionobservador::find()->asArray()->all(), 'id', 'tipo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tipo', 'id' => 'grid-observador-search-tipo_observacion']
            ],
        [
            'attribute' => 'descripcion',
            'visible' => false,
        ], 
        [
            'attribute' => 'descargos',
            'visible' => false,
        ], 
        [
            'attribute' => 'proceso',
            'visible' => false,
        ], 
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class'=>'kartik\grid\ActionColumn',
            'template' => '{save-as-new} {view} {update} {delete}',
            'buttons' => [
                'save-as-new' => function ($url) {
                    return Html::a('<span class="glyphicon glyphicon-copy"></span>', $url, ['title' => 'Save As New']);
                },
            ],
            'dropdown'=>false,
            'order'=>DynaGrid::ORDER_FIX_RIGHT,
        ],
        ['class'=>'kartik\grid\CheckboxColumn',  'order'=>DynaGrid::ORDER_FIX_RIGHT],
    ]; 
    ?>
<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'academico'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>


</div>
