<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;
use backend\models\Tercero;
/* @var $this yii\web\View */
/* @var $model backend\models\Observador */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Observador', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="observador-view">

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'estudiantes.nombre',
            'label' => 'Estudiante',
        ],
        [
            'attribute' => 'comprometidos',
            'format' => 'raw',
            'value' => function($model){

                $comprometidos = explode(',', $model->comprometidos);
                $estudiantes ='';
                foreach ($comprometidos as $comprometido) 
                {
                    $tercero = Tercero::find()->where(['id' => $comprometido])->one();
                    $estudiantes .= $tercero->nombre.'<br>';
                }

                return $estudiantes;
            }
        ],
        
        [
            'attribute' => 'momentos.momento',
            'label' => 'Momento',
        ],
        [
            'attribute' => 'asignaturas.asignatura',
            'label' => 'Asignatura',
        ],
        [
            'attribute' => 'periodos.periodo',
            'label' => 'Periodo',
        ],
        'fecha',
        [
            'attribute' => 'docentes.nombre',
            'label' => 'Docente',
        ],
        [
            'attribute' => 'claseObservacion.clase',
            'label' => 'Clase Observacion',
        ],
        [
            'attribute' => 'tipoobservacion.tipo',
            'label' => 'Tipo Observación',
        ],
        [
            'attribute' => 'descripcion',
            'format' => 'raw',
        ],
        [
            'attribute' => 'descargos',
            'format' => 'raw',
        ],
        [
            'attribute' => 'proceso',
            'format' => 'raw',
        ]
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
</div>