<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\base\Observaciongeneral */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Observaciongenerals', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="observaciongeneral-view">

    <div class="row">
        <div class="col-sm-12">
            <h2><?= 'Observaciongeneral'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'observacion:ntext',
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
</div>
