<?php

use yii\helpers\Html;

use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\widgets\ActiveForm;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\widgets\TouchSpin;


use backend\models\Sede;
use backend\models\Tercero;
use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Competencia;


$this->title = 'Observaciones Generales';
$this->params['breadcrumbs'][] = ['label' => 'Observaciones Generales', 'url' => ['index']];

$this->registerJs("
    $(document).ready(function(){

     load_data();

     function load_data(query)
     {
        $('#result').html('<div style=\'text-align:center;\'><img src=\'".Url::to('@web/images/loading.gif')."\' width=\'50px\' height=\'50px\'></div>');   
        
          $.ajax({
           url:'".Url::to(['buscar'])."',
           method:'POST',
           data:{query:query, id: ".Yii::$app->request->get('id')." },
           success:function(data)
           {
            $('#result').html(data);
           }
          });
     }
     
     $('#observaciongeneral-observacion').keyup(function(){
          var search = $(this).val();
          if(search != '')
          {
            load_data(search);
          }
          else
          {
            load_data();
          }
      });
    });

");

?>
     <?php $form = ActiveForm::begin([
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                    ]
    ]); ?>


<div class="row">

    <div class="col-sm-10 col-xs-12">

            <div class="col-sm-12 col-xs-12">
                <?= $form->field($model, 'observacion', [
                    'addon' => ['prepend' => ['content'=>'<i class="fas fa-search"></i>']],
                    ])->label(false); 
                ?>
            </div>

            <div id="resultados" class="col-sm-12 col-xs-12" style="max-height: 392px; overflow-y: scroll;">
                <div id="result">
                    <?= "<div style='text-align:center;'><img src='".Url::to('@web/images/loading.gif')."' width='50px' height='50px'></div>"; ?>
                </div>
            </div>        
           
    </div>

    <div class="col-sm-2 hidden-xs">
        <?= Html::img('@web/images/sonic-search.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed; z-index:0;']); ?>
    </div>


    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align:right; padding-top: 10px;">
        <?= Html::a('<i class="fa fa-times" aria-hidden="true"></i><span> Cancelar', false , ['class'=> 'btn btn-danger', 'data-dismiss' => 'modal']) ?>        
    </div>

    
</div>



