<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\widgets\TouchSpin;

?>



   <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                    ]
    ]); ?>
    
<div class="row">
    <div class = "col-sm-12">
        <?= $form->errorSummary($model); ?>
    </div>
</div>


<div class="row gutter">
    <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
        <div class="thumbnail" style="padding:10px;">
            <?= Html::img('@web/images/Sonic-Logo.png', ['class'=>'img-responsive']); ?>

            
        </div>
        <div class="thumbnail" style="padding:20px;">
            <div class="row">
                <div class="col-sm-12">
                    <h4 class="center-align-text text-primary" style="display:block;">Parámetros del Sistema</h4>
                </div>
            </div>
        </div>
    </div>       


            
    <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#informacion"><?= Yii::t('app', 'Información') ?></a></li>
            <li class=""><a data-toggle="tab" href="#mail"><?= Yii::t('app', 'Correo Electrónico') ?></a></li>
            <li class=""><a data-toggle="tab" href="#cloud"><?= Yii::t('app', 'Cloud') ?></a></li>
            <li class=""><a data-toggle="tab" href="#sms"><?= Yii::t('app', 'Mensajes de Texto') ?></a></li>
            <li class=""><a data-toggle="tab" href="#maps"><?= Yii::t('app', 'Mapas') ?></a></li>
        </ul>
        <div class="tab-content">

            <div id="informacion" class="tab-pane active">
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'online')->widget(SwitchInput::classname()) ?>    
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'app_name')->textInput(['maxlength' => true, 'placeholder' => 'App Name']) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'mail_admin')->textInput(['maxlength' => true, 'placeholder' => 'Mail Admin']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'mail_support')->textInput(['maxlength' => true, 'placeholder' => 'Mail Support']) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cookie_validation_key_front')->textInput(['maxlength' => true, 'placeholder' => 'Cookie Validation Key Front']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cookie_validation_key_back')->textInput(['maxlength' => true, 'placeholder' => 'Cookie Validation Key Back']) ?>
                    </div>
                </div>
            </div>  <!-- FIN TAB 1  -->


            <div id="mail" class="tab-pane">
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'mail_activo')->widget(SwitchInput::classname()) 
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'mail_host')->textInput(['maxlength' => true, 'placeholder' => 'Mail Host']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'mail_user')->textInput(['maxlength' => true, 'placeholder' => 'Mail User']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'mail_password')->textInput(['maxlength' => true, 'placeholder' => 'Mail Password']) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'mail_port')->textInput(['maxlength' => true, 'placeholder' => 'Mail Port']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'mail_encryption')->textInput(['maxlength' => true, 'placeholder' => 'Mail Encryption']) ?>
                        
                    </div>
                </div>
            </div>  <!-- FIN TAB 2  -->

            <div id="cloud" class="tab-pane">
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'cloud_service')->widget(\kartik\widgets\Select2::classname(), [
                                'data' => ['1' => 'Local', '2' => 'Google Drive', '3' => 'Amazon S3'],
                                'options' => ['placeholder' => 'Seleccione'],
                                'pluginOptions' => [
                                    'allowClear' => true
                                ],
                            ]); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'cloud_drive_credentials')->textarea(['rows' => '6']) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cloud_drive_defecto')->textInput(['maxlength' => true, 'placeholder' => 'Cloud Drive Defecto']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cloud_drive_planesaula')->textInput(['maxlength' => true, 'placeholder' => 'Cloud Drive Planesaula']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cloud_drive_planesmejoramiento')->textInput(['maxlength' => true, 'placeholder' => 'Cloud Drive Planesmejoramiento']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cloud_drive_mensajes')->textInput(['maxlength' => true, 'placeholder' => 'Cloud Drive Mensajes']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cloud_drive_tareas')->textInput(['maxlength' => true, 'placeholder' => 'Cloud Drive Tareas']) ?>
                    </div>
                </div>


                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cloud_s3_key')->textInput(['maxlength' => true, 'placeholder' => 'Cloud S3 Key']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cloud_s3_secret')->textInput(['maxlength' => true, 'placeholder' => 'Cloud S3 Secret']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cloud_s3_region')->textInput(['maxlength' => true, 'placeholder' => 'Cloud S3 Region']) ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'cloud_s3_bucket')->textInput(['maxlength' => true, 'placeholder' => 'Cloud S3 Bucket']) ?>
                    </div>
                </div>
            </div>  <!-- FIN TAB 3  -->

            <div id="sms" class="tab-pane">
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'sms_activo')->widget(\kartik\widgets\Select2::classname(), [
                                'data' => ['True' => 'Activo', 'False' => 'Inactivo'],
                                'options' => ['placeholder' => 'Seleccione'],
                                'pluginOptions' => [
                                    'allowClear' => true
                                ],
                            ]); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'sms_user')->textInput(['maxlength' => true, 'placeholder' => 'Sms-user']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'sms_password')->textInput(['maxlength' => true, 'placeholder' => 'Sms-password']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'sms_institucion')->textInput(['maxlength' => true, 'placeholder' => 'Sms-institucion']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'sms_test')->textInput(['maxlength' => true, 'placeholder' => 'Sms-test']) ?>
                    </div>
                </div>
            </div>  <!-- FIN TAB 4  -->


            <div id="maps" class="tab-pane">
                <div class="row">
                    <div class="col-sm-12">
                        <?= $form->field($model, 'google_maps_activo')->widget(SwitchInput::classname()) ?>    
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($model, 'google_maps_key')->textInput(['maxlength' => true, 'placeholder' => 'Google Maps Key']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'google_maps_type')->textInput(['maxlength' => true, 'placeholder' => 'Google Maps Type']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'google_maps_tilt')->textInput(['maxlength' => true, 'placeholder' => 'Google Maps Tilt']) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($model, 'google_maps_zoom')->textInput(['maxlength' => true, 'placeholder' => 'Google Maps Zoom']) ?>
                    </div>
                </div>
            </div>  <!-- FIN TAB 4  -->


        </div>         
    </div>   
</div>  


    

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

