<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->terceros,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        'identificacion',
        [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'genero.genero',
                'label' => 'Genero'
        ],
        [
                'attribute' => 'tipoTercero.id',
                'label' => 'Tipo Tercero'
        ],
        'fecha_nacimiento',
        [
                'attribute' => 'departamento.id',
                'label' => 'Departamento Nacimiento'
        ],
        [
                'attribute' => 'municipio.id',
                'label' => 'Municipio Nacimiento'
        ],
        [
                'attribute' => 'rh.rh',
                'label' => 'Rh'
        ],
        [
                'attribute' => 'religion.religion',
                'label' => 'Religion'
        ],
        [
                'attribute' => 'etnia.etnia',
                'label' => 'Etnia'
        ],
        [
                'attribute' => 'epss.eps',
                'label' => 'Eps'
        ],
        'direccion',
        [
                'attribute' => 'barrio.id',
                'label' => 'Barrio'
        ],
        'fijo',
        'movil',
        'email:email',
        'foto',
        'acudiente',
        'estado',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'tercero'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
