<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Parentesco */

$this->title = $model->parentesco;
$this->params['breadcrumbs'][] = ['label' => 'Parentescos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="parentesco-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Parentesco'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'parentesco',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnTercero = [
        ['class' => 'yii\grid\SerialColumn'],
        'identificacion',
        [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'genero.genero',
                'label' => 'Genero'
        ],
        [
                'attribute' => 'tipoTercero.id',
                'label' => 'Tipo Tercero'
        ],
        [
                'attribute' => 'parentesco.parentesco',
                'label' => 'Parentesco'
        ],
        'fecha_nacimiento',
        [
                'attribute' => 'departamento.id',
                'label' => 'Departamento Nacimiento'
        ],
        [
                'attribute' => 'municipio.id',
                'label' => 'Municipio Nacimiento'
        ],
        [
                'attribute' => 'rh.rh',
                'label' => 'Rh'
        ],
        [
                'attribute' => 'religion.religion',
                'label' => 'Religion'
        ],
        [
                'attribute' => 'etnia.etnia',
                'label' => 'Etnia'
        ],
        [
                'attribute' => 'epss.eps',
                'label' => 'Eps'
        ],
        'direccion',
        [
                'attribute' => 'barrio.id',
                'label' => 'Barrio'
        ],
        'fijo',
        'movil',
        'email:email',
        'foto',
        'acudiente',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerTercero,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-tercero']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Tercero'.' '. $this->title),
        ],
        'columns' => $gridColumnTercero
    ]);
?>
    </div>
</div>
