<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;

?>
         <?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Periodo</h3>
    </div>

    <div class="panel-body" >
        <div class="row">
            <div class="col-sm-12">
                <?= $form->errorSummary($model); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($model, 'periodo')->textInput(['maxlength' => true, 'placeholder' => 'Periodo']) ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model, 'fecha_inicio')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATE,
                    'saveFormat' => 'php:Y-m-d',
                    'ajaxConversion' => true,
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,

                        ]
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model, 'fecha_fin')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATE,
                    'saveFormat' => 'php:Y-m-d',
                    'ajaxConversion' => true,
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,

                        ]
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">  
                <? ($model->isNewRecord) ? $model->habilitado = true: ''; ?>

                <?= $form->field($model, 'habilitado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'onText'=>'Habilitado',
                    'offText'=>'Deshabilitado'
                ]]) 
                ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($model, 'autorizar_calificaciones')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'onText'=>'Si',
                    'offText'=>'No'
                ]]) 
                ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model, 'calificaciones_inicio')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,

                        ]
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model, 'calificaciones_fin')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,

                        ]
                    ],
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($model, 'autorizar_nivelaciones')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'onText'=>'Si',
                    'offText'=>'No'
                ]]) 
                ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model, 'nivelaciones_inicio')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,

                        ]
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model, 'nivelaciones_fin')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,

                        ]
                    ],
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">  
                <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

                <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'medium',
                    'onColor' => 'success',
                    'offColor' => 'danger',
                    'onText'=>'Activo',
                    'offText'=>'Inactivo'
                ]]) 
                ?>
            </div>
        </div>
    </div>        
</div>

    <?php ActiveForm::end(); ?>


