<div class="form-group" id="add-observacion-frd">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'ObservacionFrd',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        'id' => ['type' => TabularForm::INPUT_HIDDEN],
        'tipo_observacion' => [
            'label' => 'Tipo observacion',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\TipoObservacion::find()->orderBy('tipo_observacion')->asArray()->all(), 'id', 'tipo_observacion'),
                'options' => ['placeholder' => 'Choose Tipo observacion'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'grado' => [
            'label' => 'Grado',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->orderBy('grado')->asArray()->all(), 'id', 'grado'),
                'options' => ['placeholder' => 'Choose Grado'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'asignatura' => [
            'label' => 'Asignatura',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Asignatura::find()->orderBy('asignatura')->asArray()->all(), 'id', 'asignatura'),
                'options' => ['placeholder' => 'Choose Asignatura'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'competencia' => [
            'label' => 'Competencia',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Competencia::find()->orderBy('competencia')->asArray()->all(), 'id', 'competencia'),
                'options' => ['placeholder' => 'Choose Competencia'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'observacion' => ['type' => TabularForm::INPUT_TEXTAREA],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowObservacionFrd(' . $key . '); return false;', 'id' => 'observacion-frd-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Observacion Frd', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowObservacionFrd()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

