<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;

use yii\helpers\ArrayHelper;


?>
         <?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario'.$model2->id,
                        ]
        ]); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del Periodo</h3>
    </div>

    <div class="panel-body" >
        <div class="row">
            <div class="col-sm-12">
                <?= $form->errorSummary($model2); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($model2, 'periodo')->textInput(['maxlength' => true, 'placeholder' => 'Periodo']) ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model2, 'fecha_inicio')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATE,
                    'saveFormat' => 'php:Y-m-d',
                    'ajaxConversion' => true,
                    'options' => ['id' => 'periodo-'.$model2->id.'-fecha-inicio'],
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                        ]
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model2, 'fecha_fin')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATE,
                    'saveFormat' => 'php:Y-m-d',
                    'ajaxConversion' => true,
                    'options' => ['id' => 'periodo-'.$model2->id.'-fecha-fin'],
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                        ]
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">  
                <? ($model2->isNewRecord) ? $model2->habilitado = true: ''; ?>

                <?= $form->field($model2, 'habilitado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'onText'=>'Habilitado',
                    'offText'=>'Deshabilitado'
                    ],
                    'options' => ['id' => 'periodo-'.$model2->id.'-habilitado'],
                    ]) 
                ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($model2, 'autorizar_calificaciones')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'onText'=>'Si',
                    'offText'=>'No'
                ],
                'options' => ['id' => 'periodo-'.$model2->id.'-autorizar_calificaciones'],
                ]) 
                ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model2, 'calificaciones_inicio')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'options' => ['id' => 'periodo-'.$model2->id.'-calificaciones_inicio'],
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                        ]
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model2, 'calificaciones_fin')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'options' => ['id' => 'periodo-'.$model2->id.'-calificaciones_fin'],
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                        ]
                    ],
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($model2, 'autorizar_nivelaciones')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'onText'=>'Si',
                    'offText'=>'No'
                ],
                'options' => ['id' => 'periodo-'.$model2->id.'-autorizar_nivelaciones'],
                ]) 
                ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model2, 'nivelaciones_inicio')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'options' => ['id' => 'periodo-'.$model2->id.'-nivelaciones_inicio'],
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                        ]
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">  
                <?= $form->field($model2, 'nivelaciones_fin')->widget(\kartik\datecontrol\DateControl::classname(), [
                    'type' => \kartik\datecontrol\DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'options' => ['id' => 'periodo-'.$model2->id.'-nivelaciones_fin'],
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                        ]
                    ],
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">  
                <? ($model2->isNewRecord) ? $model2->estado = true: ''; ?>

                <?= $form->field($model2, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'medium',
                    'onColor' => 'success',
                    'offColor' => 'danger',
                    'onText'=>'Activo',
                    'offText'=>'Inactivo'
                ],
                'options' => ['id' => 'periodo-'.$model2->id.'-estado'],
                ]) 
                ?>
            </div>
        </div>
        <div class="form-group">
            <?= Html::submitButton($model2->isNewRecord ? 'Create' : 'Update', ['class' => $model2->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        </div>
    </div>        
</div>

    <?php ActiveForm::end(); ?>


