<div class="form-group" id="add-plan-aula">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'PlanAula',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        'id' => ['type' => TabularForm::INPUT_HIDDEN],
        'docente' => [
            'label' => 'Tercero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tercero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'rango' => ['type' => TabularForm::INPUT_TEXT],
        'semana_inicio' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATE,
                'saveFormat' => 'php:Y-m-d',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Semana Inicio',
                        'autoclose' => true
                    ]
                ],
            ]
        ],
        'semana_fin' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\datecontrol\DateControl::classname(),
            'options' => [
                'type' => \kartik\datecontrol\DateControl::FORMAT_DATE,
                'saveFormat' => 'php:Y-m-d',
                'ajaxConversion' => true,
                'options' => [
                    'pluginOptions' => [
                        'placeholder' => 'Choose Semana Fin',
                        'autoclose' => true
                    ]
                ],
            ]
        ],
        'grado' => [
            'label' => 'Grado',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->orderBy('grado')->asArray()->all(), 'id', 'grado'),
                'options' => ['placeholder' => 'Choose Grado'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'asignatura' => [
            'label' => 'Asignatura',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Asignatura::find()->orderBy('asignatura')->asArray()->all(), 'id', 'asignatura'),
                'options' => ['placeholder' => 'Choose Asignatura'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'grupo' => [
            'label' => 'Grupo',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->orderBy('grupo')->asArray()->all(), 'id', 'grupo'),
                'options' => ['placeholder' => 'Choose Grupo'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'estandar' => ['type' => TabularForm::INPUT_TEXTAREA],
        'competencia' => [
            'label' => 'Competencia',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Competencia::find()->orderBy('competencia')->asArray()->all(), 'id', 'competencia'),
                'options' => ['placeholder' => 'Choose Competencia'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'unidad' => ['type' => TabularForm::INPUT_TEXT],
        'nombre_unidad' => ['type' => TabularForm::INPUT_TEXT],
        'horas' => ['type' => TabularForm::INPUT_TEXT],
        'derechos' => ['type' => TabularForm::INPUT_TEXTAREA],
        'inicio' => ['type' => TabularForm::INPUT_TEXTAREA],
        'desarrollo' => ['type' => TabularForm::INPUT_TEXTAREA],
        'cierre' => ['type' => TabularForm::INPUT_TEXTAREA],
        'formativa' => ['type' => TabularForm::INPUT_TEXTAREA],
        'articulacion' => ['type' => TabularForm::INPUT_TEXTAREA],
        'recursos' => ['type' => TabularForm::INPUT_TEXTAREA],
        'reflexion' => ['type' => TabularForm::INPUT_TEXTAREA],
        'observaciones' => ['type' => TabularForm::INPUT_TEXTAREA],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowPlanAula(' . $key . '); return false;', 'id' => 'plan-aula-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Plan Aula', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowPlanAula()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

