<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\datecontrol\DateControl;
use kartik\widgets\DateTimePicker;
use kartik\widgets\DatePicker;
use yii\helpers\ArrayHelper;


?>
  

<div class="panel panel-default">
    <div class="panel-heading">
        <?= Html::submitButton('<i class="fas fa-save"></i> Guardar', ['class' => 'btn btn-link btn-xs text-primary', 'style' => 'float:right;']) ?>
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información del <?= $model->periodo ?>
            <?= $model->habilitado == 1 ? '<span class="label label-block label-primary">Habilitado</span>' : ''; ?>
        </h3>
    </div>

    <div class="panel-body" >
        <div class="row">
            <div class="col-sm-12">
                <?= $form->errorSummary($model); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-4">
                <?= $form->field($model, "[$index]periodo")->textInput(['maxlength' => true, 'placeholder' => 'Periodo']) ?>
            </div>
            <div class="col-sm-4">  
                <?= $form->field($model, "[$index]fecha_inicio")->widget(DatePicker::classname(), [
                    'pluginOptions' => [
                        'autoclose'=>true,
                        'format' => 'yyyy-mm-dd'
                    ]    
                ]); ?>
            </div>
            <div class="col-sm-4">  
                <?= $form->field($model, "[$index]fecha_fin")->widget(DatePicker::classname(), [
                    'pluginOptions' => [
                        'autoclose'=>true,
                        'format' => 'yyyy-mm-dd'
                    ]    
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-4">
                <?= $form->field($model, "[$index]autorizar_calificaciones")->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'onText'=>'Si',
                    'offText'=>'No'
                ],
                'options' => ['id' => 'periodo-'.$model->id.'-autorizar_calificaciones'],
                ]) 
                ?>
            </div>
            <div class="col-sm-4">
                <?= $form->field($model, "[$index]autorizar_nivelaciones")->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'onText'=>'Si',
                    'offText'=>'No'
                ],
                'options' => ['id' => 'periodo-'.$model->id.'-autorizar_nivelaciones'],
                ]) 
                ?>
            </div>
            <div class="col-sm-4"> 
                <div class="form-group highlight-addon">
                    <label class="control-label">&nbsp;</label>
                    <div class="form-group">
                        <?= Html::submitButton('<i class="fas fa-save"></i> Guardar', ['class' => 'btn btn-primary']) ?>    
                    </div>
                </div>

                
            </div>
        </div>
<!--
        <div class="row">

            <div class="col-sm-4">  
                <?= $form->field($model, "[$index]calificaciones_inicio")->widget(DateTimePicker::classname(), [
                    'options' => ['placeholder' => Yii::t('app', 'Seleccione')],
                    'pluginOptions' => [
                        'autoclose' => true,
                        'format' => 'yyyy-mm-dd HH:ii:ss'
                    ]
                ]); ?>
            </div>
            <div class="col-sm-4">  
                <?= $form->field($model, "[$index]calificaciones_fin")->widget(DateTimePicker::classname(), [
                    'options' => ['placeholder' => Yii::t('app', 'Seleccione')],
                    'pluginOptions' => [
                        'autoclose' => true,
                        'format' => 'yyyy-mm-dd HH:ii:ss'
                    ]
                ]); ?>

                <? $form->field($model, "[$index]calificaciones_fin")->widget(DateControl::classname(), [
                    'type' => DateControl::FORMAT_DATETIME,
                    //'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'options' => ['id' => 'periodo-'.$model->id.'-calificaciones_fin'],
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                        ]
                    ],
                ]); ?>
            </div>
            
            <div class="col-sm-4">  
                <?= $form->field($model, "[$index]nivelaciones_inicio")->widget(DateTimePicker::classname(), [
                    'options' => ['placeholder' => Yii::t('app', 'Seleccione')],
                    'pluginOptions' => [
                        'autoclose' => true,
                        'format' => 'yyyy-mm-dd HH:ii:ss'
                    ]
                ]); ?>

                <? $form->field($model, "[$index]nivelaciones_inicio")->widget(DateControl::classname(), [
                    'type' => DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'options' => ['id' => 'periodo-'.$model->id.'-nivelaciones_inicio'],
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                        ]
                    ],
                ]); ?>
            </div>
            <div class="col-sm-4">  
                <?= $form->field($model, "[$index]nivelaciones_fin")->widget(DateTimePicker::classname(), [
                    'options' => ['placeholder' => Yii::t('app', 'Seleccione')],
                    'pluginOptions' => [
                        'autoclose' => true,
                        'format' => 'yyyy-mm-dd HH:ii:ss'
                    ]
                ]); ?>

                <? $form->field($model, "[$index]nivelaciones_fin")->widget(DateControl::classname(), [
                    'type' => DateControl::FORMAT_DATETIME,
                    'saveFormat' => 'php:Y-m-d H:i:s',
                    'ajaxConversion' => true,
                    'options' => ['id' => 'periodo-'.$model->id.'-nivelaciones_fin'],
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                        ]
                    ],
                ]); ?>
            </div>
        </div>-->

        
    </div>        
</div>

